package cn.wisenergy.chnmuseum.party.service.impl;

import cn.wisenergy.chnmuseum.party.model.Role;
import cn.wisenergy.chnmuseum.party.service.IMenuService;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import cn.wisenergy.chnmuseum.party.mapper.MenuMapper;
import cn.wisenergy.chnmuseum.party.model.Menu;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;

/**
 * <p>
 * 菜单权限表 服务实现类
 * </p>
 *
 * @author 杨智平
 * @since 2018-08-03
 */
@Service
public class MenuServiceImpl extends ServiceImpl<MenuMapper, Menu> implements IMenuService {

    @Resource
    private MenuMapper menuMapper;

    public List<Menu> getUserMenuPerms(List<String> list) {
        List<Menu> menuList = menuMapper.getUserMenuPerms(list);
        HashMap<String, Menu> map = new HashMap<>();
        menuList.forEach(m->map.put(m.getId(),m));
        for (Menu menu : menuList) {
            Menu parent = map.get(menu.getParentId());
            if (parent!=null){
                if (parent.getChildren()==null){
                    parent.setChildren(new ArrayList<>());
                }
                parent.getChildren().add(menu);
            }
        }
        menuList = menuList.stream().filter(m -> m.getLevel()==1).collect(Collectors.toList());
        return menuList;
    }

}
