package cn.wisenergy.chnmuseum.party.service.impl;

import cn.wisenergy.chnmuseum.party.model.TArea;
import cn.wisenergy.chnmuseum.party.mapper.TAreaMapper;
import cn.wisenergy.chnmuseum.party.model.TOrgan;
import cn.wisenergy.chnmuseum.party.service.TAreaService;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;

import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.beans.factory.annotation.Autowired;

import javax.annotation.Resource;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * <pre>
 * 区域表 服务实现类
 * </pre>
 *
 * @author Danny Lee
 * @since 2021-03-24
 */
@Slf4j
@Service
public class TAreaServiceImpl extends ServiceImpl<TAreaMapper, TArea> implements TAreaService {

    @Resource
    private TAreaMapper areaMapper;

    @Override
    public List<TArea> getAreaTree() {
        List<TArea> list = list();
        HashMap<String, TArea> map = new HashMap<>();
        list.forEach(o-> map.put(o.getId().toString(),o));
        for (TArea o : list) {
            TArea area= map.get(o.getParentId());
            if(area!=null){
                //说明有值
                if(area.getChildren()==null){
                    area.setChildren(new ArrayList<>());
                }
                area.getChildren().add(o);
            }
        }
        list = list.stream().filter(o -> o.getType().equals("P")).collect(Collectors.toList());
        return list;
    }

    public List<Map<String,String>> languageInfo() {
        return areaMapper.languageInfo();
    }
}
