package cn.wisenergy.chnmuseum.party.vo;

import cn.wisenergy.chnmuseum.party.model.*;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.*;
import lombok.experimental.Accessors;

import java.io.Serializable;

@ApiModel("统计数据")
@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
public class StatisticData implements Serializable {
    /**
     * 看板播放排行
     */
    @ApiModelProperty(value = "展板播放排行", name = "name")
    private BoardPlayRank boardPlayRank;
    /**
     * 数据汇总
     */
    @ApiModelProperty("播放数据统计")
    private Statistic totalStatistic;
    /**
     * 地区看板播放统计
     */
    @ApiModelProperty("地区展板播放统计")
    private DistrictBoardStatistic districtBoard;

    /*** 互动频次
     */
    @ApiModelProperty("互动频次")
    private InteractionRank interactionRank;
    /**
     * 看板点播趋势
     */
    @ApiModelProperty("展板播放趋势")
    private BoardPlayTrend boardPlayTrend;
}
