package cn.wisenergy.chnmuseum.party.web.controller;

import cn.wisenergy.chnmuseum.party.model.Index;
import cn.wisenergy.chnmuseum.party.service.IndexService;
import cn.wisenergy.chnmuseum.party.web.controller.base.BaseController;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;
import java.util.List;

/**
 * <p>
 * 首页使用
 * </p>
 *
 * @author 杨建龙
 * @since 2018-10-08
 */
@Api(tags = "首页使用")
@RestController
@RequestMapping("/index")
public class IndexController extends BaseController {

    private static final Logger logger = LoggerFactory.getLogger(IndexController.class);

    @Resource
    private IndexService indexService;

    /**
     * 获取首页列表数据
     *
     * @return
     */
    @ApiOperation(value = "获取首页列表数据")
    @GetMapping(value = "/getIndexList")
    @RequiresPermissions("/index/getIndexList")
    public ResponseEntity<List<Index>> getIndexList(String roleId, String bankBranchId, String userId) {
        try {
            List<Index> indexList = this.indexService.getIndexList(roleId, bankBranchId);
            return ResponseEntity.ok(indexList);
        } catch (Exception e) {
            logger.error("获取首页列表数据出错!", e);
        }
        return ResponseEntity.status(HttpStatus.INTERNAL_SERVER_ERROR).body(null);
    }

}

