package cn.wisenergy.chnmuseum.party.web.controller;

import cn.wisenergy.chnmuseum.party.model.Menu;
import cn.wisenergy.chnmuseum.party.model.Role;
import cn.wisenergy.chnmuseum.party.vo.StatisticData;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import cn.wisenergy.chnmuseum.party.web.controller.base.BaseController;
import cn.wisenergy.chnmuseum.party.model.Statistic;
import cn.wisenergy.chnmuseum.party.service.StatisticService;
import cn.wisenergy.chnmuseum.party.common.enums.AuditStatusEnum;
import cn.wisenergy.chnmuseum.party.common.validator.groups.Add;
import cn.wisenergy.chnmuseum.party.common.validator.groups.Update;
import cn.wisenergy.chnmuseum.party.common.vo.GenericPageParam;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;

import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;
import org.springframework.stereotype.Controller;

import javax.annotation.Resource;
import javax.validation.constraints.NotNull;
import java.util.List;
import java.util.Map;

/**
 * <pre>
 * 大屏统计数据 前端控制器
 * </pre>
 *
 * @author Danny Lee
 * @since 2021-03-20
 */
@Slf4j
@RestController
@RequestMapping("/screen")
@Api(tags = {"统计数据"})
public class StatisticController extends BaseController {

    @Resource
    private StatisticService statisticService;

    @GetMapping("/statistic")
    @ApiOperation(value = "统计数据", notes = "统计数据")
    public ResponseEntity<StatisticData> getScreenData() {
		return ResponseEntity.ok(new StatisticData());
    }



}

