package cn.wisenergy.chnmuseum.party.web.controller;

import cn.wisenergy.chnmuseum.party.common.log.OperType;
import cn.wisenergy.chnmuseum.party.common.util.DateUtil80;
import cn.wisenergy.chnmuseum.party.common.util.NetWorkUtil;
import cn.wisenergy.chnmuseum.party.common.vo.GenericPageParam;
import cn.wisenergy.chnmuseum.party.model.RunLog;
import cn.wisenergy.chnmuseum.party.model.SysLog;
import cn.wisenergy.chnmuseum.party.model.TOperationLog;
import cn.wisenergy.chnmuseum.party.model.TUser;
import cn.wisenergy.chnmuseum.party.service.TOperationLogService;
import cn.wisenergy.chnmuseum.party.service.impl.RunLogServiceImpl;
import cn.wisenergy.chnmuseum.party.service.impl.SysLogServiceImpl;
import cn.wisenergy.chnmuseum.party.web.controller.base.BaseController;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.apache.commons.lang3.StringUtils;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Map;

@RestController
@RequestMapping("/sysLog")
@Api(tags = {"日志管理接口"})
public class SysLogController extends BaseController {

    @Resource
    private SysLogServiceImpl sysLogService;

    @Resource
    private RunLogServiceImpl runLogService;

    @Resource
    private TOperationLogService operationLogService;

    /**
     * 插入系统日志表
     */
    @ApiOperation(value = "插入系统日志", notes = "插入系统日志")
    @PostMapping(value = "/insertSysLog")
    public Boolean insertSysLog(String operationContent, TUser user) {
        SysLog sysLog = new SysLog();
        //日志时间
        sysLog.setOperationTime(DateUtil80.getDateTimeOfTimestamp(System.currentTimeMillis()));
        //获取登录IP并插入
        ServletRequestAttributes attributes = (ServletRequestAttributes) RequestContextHolder.getRequestAttributes();
        HttpServletRequest request = attributes.getRequest();
        String operationIp = NetWorkUtil.getLoggableAddress(request);
        sysLog.setOperationIp(operationIp);
        if (user.getUserName() == null) {
            //操作者用户名
            sysLog.setOperator(this.getUserName());
        } else {
            sysLog.setOperator(user.getUserName());
        }
        if (user.getRoleList().contains("1")) {
            sysLog.setType(1);
        } else {
            sysLog.setType(2);
        }
        //日志内容
        sysLog.setOperationContent(operationContent);
        sysLog.setOperationObject("登录管理");
        sysLog.setOperationType("登录");
        Boolean ret = this.sysLogService.save(sysLog);
        return ret;
    }

    /**
     * 查询系统日志
     */
    @ApiOperation(value = "查询系统日志", notes = "查询系统日志")
    @ApiImplicitParams(value = {
            @ApiImplicitParam(name = "_index", value = "分页起始偏移量", paramType = "query", dataType = "Integer"),
            @ApiImplicitParam(name = "_size", value = "返回条数", paramType = "query", dataType = "Integer"),
            @ApiImplicitParam(name = "nameOrCode", value = "名称或编码", paramType = "query", dataType = "String"),
            @ApiImplicitParam(name = "startDate", value = "创建时间-开始", paramType = "query", dataType = "String"),
            @ApiImplicitParam(name = "endDate", value = "创建时间-结束", paramType = "query", dataType = "String"),
            @ApiImplicitParam(name = "type", value = "日志类型", paramType = "query", dataType = "Integer"),
            @ApiImplicitParam(name = "operationType", value = "操作类型", paramType = "query", dataType = "String")
    })
    @GetMapping(value = "/querySysLogList")
    @RequiresPermissions("/sysLog/querySysLogList")
    public Map<String, Object> querySysLogList(GenericPageParam genericPageParam) {
        try {
            LambdaQueryWrapper<SysLog> queryWrapper = new LambdaQueryWrapper<>();
            // 对名称或编码模糊查询
            if (StringUtils.isNotBlank(genericPageParam.getNameOrCode())) {
                queryWrapper.like(SysLog::getOperator, genericPageParam.getNameOrCode());
            }
            if (StringUtils.isNotBlank(genericPageParam.getType())) {
                queryWrapper.eq(SysLog::getType, genericPageParam.getType());
            }
            if (StringUtils.isNotBlank(genericPageParam.getOperationType())) {
                queryWrapper.eq(SysLog::getOperationType,genericPageParam.getOperationType());
            }
            // 根据创建时间区间检索
            if (genericPageParam.getStartDate() != null && genericPageParam.getEndDate() != null) {
                queryWrapper.ge(SysLog::getOperationTime, genericPageParam.getStartDate().atTime(0, 0, 0))
                        .le(SysLog::getOperationTime, genericPageParam.getEndDate().atTime(23, 59, 59));
            }
            // 设置排序规则
            queryWrapper.orderByDesc(SysLog::getOperationTime);
            Page<SysLog> page = sysLogService.page(getPage(), queryWrapper);
            return getResult(page);
        } catch (Exception e) {
            logger.error("查询系统日志列表出错!", e);
        }
        return getFailResult();
    }

    /**
     * 插入机顶盒日志表
     */
    @ApiOperation(value = "插入机顶盒日志表", notes = "插入机顶盒日志表")
    @PostMapping(value = "/insertRunLog")
    public Boolean insertRunLog(RunLog runLog) {
        boolean b = false;
        try {
            b = runLogService.insertRunLog(runLog);
            return b;
        } catch (Exception e) {
            e.printStackTrace();
        }
        return b;
    }

    /**
     * 插入运维日志表
     */
    @ApiOperation(value = "插入运维日志表", notes = "插入运维日志表")
    @PostMapping(value = "/insertOperationLog")
    public Boolean insertOperationLog(TOperationLog tOperationLog) {
        tOperationLog.setCreateTime(LocalDateTime.now());
        boolean b = false;
        try {
            b = operationLogService.save(tOperationLog);
            return b;
        } catch (Exception e) {
            e.printStackTrace();
        }
        return b;
    }

    /**
     * 查询运维日志
     */
    @ApiOperation(value = "查询运维日志", notes = "查询运维日志")
    @ApiImplicitParams(value = {
            @ApiImplicitParam(name = "_index", value = "分页起始偏移量", paramType = "query", dataType = "Integer"),
            @ApiImplicitParam(name = "_size", value = "返回条数", paramType = "query", dataType = "Integer"),
            @ApiImplicitParam(name = "userName", value = "运维账号", paramType = "query", dataType = "String"),
            @ApiImplicitParam(name = "startDate", value = "创建时间-开始", paramType = "query", dataType = "String"),
            @ApiImplicitParam(name = "endDate", value = "创建时间-结束", paramType = "query", dataType = "String")
    })
    @GetMapping(value = "/OperationLog")
    @RequiresPermissions("/sysLog/OperationLog")
    public Map<String, Object> OperationLog(TOperationLog operationLog) {
        try {
            Page<TOperationLog> page = operationLogService.pageList(getPage(), operationLog);
            return getResult(page);
        } catch (Exception e) {
            logger.error("查询系统日志列表出错!", e);
        }
        return getFailResult();
    }

    /**
     * 查询机顶盒日志
     */
    @ApiOperation(value = "查询机顶盒日志", notes = "查询机顶盒日志")
    @ApiImplicitParams(value = {
            @ApiImplicitParam(name = "_index", value = "分页起始偏移量", paramType = "query", dataType = "Integer"),
            @ApiImplicitParam(name = "_size", value = "返回条数", paramType = "query", dataType = "Integer"),
            @ApiImplicitParam(name = "nameOrCode", value = "名称或编码", paramType = "query", dataType = "String"),
            @ApiImplicitParam(name = "startDate", value = "创建时间-开始", paramType = "query", dataType = "String"),
            @ApiImplicitParam(name = "endDate", value = "创建时间-结束", paramType = "query", dataType = "String")
    })
    @GetMapping(value = "/runLogList")
    @RequiresPermissions("/sysLog/runLogList")
    public Map<String, Object> runLogList(RunLog runLog) {
        try {
            Page<RunLog> page = runLogService.pageList(getPage(), runLog);
            return getResult(page);
        } catch (Exception e) {
            logger.error("查询系统日志列表出错!", e);
        }
        return getFailResult();
    }


    /**
     * 返回日志操作类型
     * @param
     * @return
     */
    @PostMapping("/getOperationType")
    @RequiresPermissions("/sysLog/getOperationType")
    @ApiOperation(value = "返回日志操作类型", notes = "返回日志操作类型")
    public Map<String, Object> getTInteractionPageList() {
        OperType[] values = OperType.values();
        ArrayList<String> list = new ArrayList<>();
        for (OperType value : values) {
            list.add(value.getMsg());
        }
        return getResult(list);
    }

}

