package cn.wisenergy.chnmuseum.party.web.controller;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import cn.wisenergy.chnmuseum.party.web.controller.base.BaseController;
import cn.wisenergy.chnmuseum.party.model.TAppRunPic;
import cn.wisenergy.chnmuseum.party.service.TAppRunPicService;
import cn.wisenergy.chnmuseum.party.common.enums.AuditStatusEnum;
import cn.wisenergy.chnmuseum.party.common.validator.groups.Add;
import cn.wisenergy.chnmuseum.party.common.validator.groups.Update;
import cn.wisenergy.chnmuseum.party.common.vo.GenericPageParam;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;

import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;
import org.springframework.stereotype.Controller;

import javax.annotation.Resource;
import javax.validation.constraints.NotNull;
import java.util.List;
import java.util.Map;

/**
 * <pre>
 *  前端控制器
 * </pre>
 *
 * @author Danny Lee
 * @since 2021-03-29
 */
@Slf4j
@RestController
@RequestMapping("/tAppRunPic")
@Api(tags = {"APP运行界面操作接口"})
public class TAppRunPicController extends BaseController {

    @Resource
    private TAppRunPicService tAppRunPicService;

    @PostMapping("/batchSave")
		@RequiresPermissions("t:app:run:pic:batch:save")
		@ApiOperation(value = "批量添加", notes = "批量添加")
    public Map<String, Object> batchSaveTAppRunPic(@Validated(value = {Add.class}) List<TAppRunPic> tAppRunPicList) {
        // 保存业务节点信息
        boolean result = tAppRunPicService.saveBatch(tAppRunPicList);
        // 返回操作结果
        if (result) {
            return getSuccessResult();
        } else {
            // 保存失败
            return getFailResult();
        }
    }

    @PostMapping("/save")
		@RequiresPermissions("t:app:run:pic:save")
		@ApiOperation(value = "添加", notes = "添加")
	public Map<String, Object> saveTAppRunPic(@Validated(value = {Add.class}) TAppRunPic tAppRunPic) {
		// 默认不为当前版本
		if (tAppRunPic.getIsCurrent() == null){
			tAppRunPic.setIsCurrent(0);
		}

		// 如果有其他版本是当前版本状态，将其当前版本状态取消
		QueryWrapper<TAppRunPic> qw = new QueryWrapper<>();
		qw.eq("is_current",1);
		List<TAppRunPic> currentList = tAppRunPicService.list(qw);
		if (currentList != null && currentList.size() > 0 && tAppRunPic.getIsCurrent() == 1){
			currentList.stream().forEach(c->{
				c.setIsCurrent(0);
			});
			tAppRunPicService.updateBatchById(currentList);
		}


    	// 保存业务节点信息
        boolean result = tAppRunPicService.save(tAppRunPic);
        // 返回操作结果
        if (result) {
            return getSuccessResult();
        } else {
            // 保存失败
            return getFailResult();
        }
    }

    @PutMapping("/update")
		@RequiresPermissions("t:app:run:pic:update")
	    @ApiOperation(value = "修改信息", notes = "修改信息")
    public Map<String, Object> updateTAppRunPic(@Validated(value = {Update.class}) TAppRunPic tAppRunPic) {
		// 默认不为当前版本
		if (tAppRunPic.getIsCurrent() == null){
			tAppRunPic.setIsCurrent(0);
		}
		// 如果有其他版本是当前版本状态，将其当前版本状态取消
		QueryWrapper<TAppRunPic> qw = new QueryWrapper<>();
		qw.eq("is_current",1);
		List<TAppRunPic> currentList = tAppRunPicService.list(qw);
		if (currentList != null && currentList.size() > 0 && tAppRunPic.getIsCurrent() == 1){
			currentList.stream().forEach(c->{
				c.setIsCurrent(0);
			});
			tAppRunPicService.updateBatchById(currentList);
		}
		boolean flag = tAppRunPicService.updateById(tAppRunPic);
		if (flag) {
		return getSuccessResult();
        }
        return getFailResult();
    }

//	@PutMapping("/updateAuditStatus/{id}")
//	@RequiresPermissions("t:app:run:pic:update:audit:status")
//	@ApiOperation(value = "更新审核状态", notes = "更新审核状态")
//	@ApiImplicitParams(value = {
//			@ApiImplicitParam(name = "id", value = "标识ID", dataType = "String", paramType = "path"),
//			@ApiImplicitParam(name = "isCurrent", value = "是否为当前界面 0：否 1：是", paramType = "query", dataType = "String")
//	})
//	public Map<String, Object> updateStatus(@NotNull(message = "ID不能为空") @PathVariable("id") String id, @RequestParam("status") String isCurrent) {
//		UpdateWrapper<TAppRunPic> updateWrapper = new UpdateWrapper<>();
//		updateWrapper.eq("id", id);
//		updateWrapper.eq("is_current", isCurrent);
//		boolean flag = tAppRunPicService.update(updateWrapper);
//		if (flag) {
//		return getSuccessResult();
//		}
//		return getFailResult();
//    }

    @DeleteMapping("/delete/{id}")
		@RequiresPermissions("t:app:run:pic:delete")
		@ApiOperation(value = "根据ID删除", notes = "根据ID删除")
	@ApiImplicitParams(value = {
			@ApiImplicitParam(name = "id", value = "标识ID", paramType = "path", dataType = "String")
	})
    public Map<String, Object> deleteTAppRunPic(@PathVariable("id") String id) {
        boolean result = tAppRunPicService.removeById(id);
        if (result) {
            return getSuccessResult();
        }
        return getFailResult();
    }

    @GetMapping("/getList")
		@RequiresPermissions("t:app:run:pic:list")
		@ApiOperation(value = "获取全部列表(无分页)", notes = "获取全部列表(无分页)")
	@ApiImplicitParams(value = {
			@ApiImplicitParam(name = "isCurrent", value = "是否为当前界面 0：否 1：是", paramType = "query", dataType = "int")
	})
    public Map<String, Object> getTAppRunPicList(Integer isCurrent) {
        List<TAppRunPic> tAppRunPicList = tAppRunPicService.list(Wrappers.<TAppRunPic>lambdaQuery().eq(isCurrent!= null,TAppRunPic::getIsCurrent, isCurrent));
        return getResult(tAppRunPicList);
    }

	@ApiImplicitParams(value = {
			@ApiImplicitParam(name = "_index", value = "分页起始偏移量", paramType = "query", dataType = "Integer"),
			@ApiImplicitParam(name = "_size", value = "返回条数", paramType = "query", dataType = "Integer"),
			@ApiImplicitParam(name = "nameOrCode", value = "名称或编码", paramType = "query", dataType = "String"),
			@ApiImplicitParam(name = "startDate", value = "创建时间-开始", paramType = "query", dataType = "String"),
			@ApiImplicitParam(name = "endDate", value = "创建时间-结束", paramType = "query", dataType = "String")
	})
    @PostMapping("/getPageList")
		@RequiresPermissions("t:app:run:pic:page")
		@ApiOperation(value = "获取分页列表", notes = "获取分页列表")
    public Map<String, Object> getTAppRunPicPageList(String isCurrent) {
		LambdaQueryWrapper<TAppRunPic> queryWrapper = new LambdaQueryWrapper<>();
		// 对名称或编码模糊查询
		if (StringUtils.isNotBlank(isCurrent)) {
			queryWrapper.like(TAppRunPic::getIsCurrent, isCurrent);
		}

		Page<TAppRunPic> page = this.tAppRunPicService.page(getPage(), queryWrapper);
		for (TAppRunPic tAppRunPic : page.getRecords()) {

		}
		return getResult(page);
    }

    @ApiOperation(value = "获取详情", notes = "获取详情")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "id", value = "标识ID", dataType = "String", paramType = "path")
    })
    @GetMapping("/get/{id}")
		@RequiresPermissions("t:app:run:pic:get:id")
	    public Map<String, Object> getById(@PathVariable("id") String id) {
        TAppRunPic tAppRunPic = tAppRunPicService.getById(id);
		return getResult(tAppRunPic);
    }

}

