package cn.wisenergy.chnmuseum.party.web.controller;

import cn.wisenergy.chnmuseum.party.common.log.MethodLog;
import cn.wisenergy.chnmuseum.party.common.log.OperModule;
import cn.wisenergy.chnmuseum.party.common.log.OperType;
import cn.wisenergy.chnmuseum.party.common.util.DateUtil;
import cn.wisenergy.chnmuseum.party.model.*;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import cn.wisenergy.chnmuseum.party.web.controller.base.BaseController;
import cn.wisenergy.chnmuseum.party.service.TBoardStatisticService;
import cn.wisenergy.chnmuseum.party.common.enums.AuditStatusEnum;
import cn.wisenergy.chnmuseum.party.common.validator.groups.Add;
import cn.wisenergy.chnmuseum.party.common.validator.groups.Update;
import cn.wisenergy.chnmuseum.party.common.vo.GenericPageParam;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;

import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;
import javax.validation.constraints.NotNull;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * <pre>
 * 展板统计信息表 前端控制器
 * </pre>
 *
 * @author Danny Lee
 * @since 2021-03-25
 */
@Slf4j
@RestController
@RequestMapping("/tBoardStatistic")
@Api(tags = {"展板统计信息表操作接口"})
public class TBoardStatisticController extends BaseController {

    @Resource
    private TBoardStatisticService tBoardStatisticService;

//    @ApiImplicitParams(value = {
//            @ApiImplicitParam(name = "_index", value = "分页起始偏移量", paramType = "query", dataType = "Integer"),
//            @ApiImplicitParam(name = "_size", value = "返回条数", paramType = "query", dataType = "Integer")
//    })
    @PostMapping("/getBoardSurvey")
    @RequiresPermissions("t:board:statistic:survey")
    @ApiOperation(value = "获取展板统计概况", notes = "获取展板统计概况")
//    @MethodLog(operModule = OperModule.OVERVIEW, operType = OperType.SELECT)
    public Map<String, Object> getBoardSurvey(TBoardSurvey survey) {

        TBoardSurvey result = this.tBoardStatisticService.getBoardSurvey(survey);

        return getResult(result);
    }

    @ApiImplicitParams(value = {
            @ApiImplicitParam(name = "_index", value = "分页起始偏移量", paramType = "query", dataType = "Integer"),
            @ApiImplicitParam(name = "_size", value = "返回条数", paramType = "query", dataType = "Integer")
    })
    @PostMapping("/getBoardRankPageList")
    @RequiresPermissions("t:board:statistic:rankPage")
    @ApiOperation(value = "获取展板播放排行", notes = "获取展板播放排行")
//    @MethodLog(operModule = OperModule.OVERVIEW, operType = OperType.SELECT)
    public Map<String, Object> getBoardRankPageList(TBoardPlayRank rank) {

        Page<TBoardPlayRank> page = this.tBoardStatisticService.getBoardRankPageList(getPage(),rank);
        for (TBoardPlayRank tBoardStatistic : page.getRecords()) {

        }
        return getResult(page);
    }

    @ApiImplicitParams(value = {
            @ApiImplicitParam(name = "_index", value = "分页起始偏移量", paramType = "query", dataType = "Integer"),
            @ApiImplicitParam(name = "_size", value = "返回条数", paramType = "query", dataType = "Integer")
    })
    @PostMapping("/getBoardTrendPageList")
    @RequiresPermissions("t:board:statistic:trendPage")
    @ApiOperation(value = "获取展板播放趋势", notes = "获取展板播放趋势")
//    @MethodLog(operModule = OperModule.OVERVIEW, operType = OperType.SELECT)
    public Map<String, Object> getBoardTrendPageList(TBoardPlayTrend trend) {
        // 如果查询日志为空，则默认当月
        if (StringUtils.isEmpty(trend.getPlayDate())){
            trend.setPlayDate(DateUtil.getCurrentDate("yyyyMM"));
        }

        Page<TBoardPlayTrend> page = this.tBoardStatisticService.getBoardTrendPageList(getPage(),trend);
        // 处理数据为展板趋势图
        Map map = new HashMap();
        List dateList = new ArrayList();
        List cntList = new ArrayList();
        for (TBoardPlayTrend t : page.getRecords()) {
            dateList.add(t.getPlayDate());
            cntList.add(t.getPlayNumber());
        }
        map.put("dateList",dateList);
        map.put("cntList",cntList);
        map.put("page",page);
        return getResult(map);
    }


    @ApiImplicitParams(value = {
            @ApiImplicitParam(name = "_index", value = "分页起始偏移量", paramType = "query", dataType = "Integer"),
            @ApiImplicitParam(name = "_size", value = "返回条数", paramType = "query", dataType = "Integer")
    })
    @PostMapping("/getBoardDistrictPageList")
    @RequiresPermissions("t:board:statistic:districtPage")
    @ApiOperation(value = "获取地区展板播统计", notes = "获取地区展板播统计")
//    @MethodLog(operModule = OperModule.OVERVIEW, operType = OperType.SELECT)
    public Map<String, Object> getBoardDistrictPageList(TDistrictBoardStatistic district) {

        Page<TDistrictBoardStatistic> page = this.tBoardStatisticService.getBoardDistrictPageList(getPage(),district);
        for (TDistrictBoardStatistic tBoardStatistic : page.getRecords()) {

        }
        return getResult(page);
    }

    @ApiImplicitParams(value = {
            @ApiImplicitParam(name = "_index", value = "分页起始偏移量", paramType = "query", dataType = "Integer"),
            @ApiImplicitParam(name = "_size", value = "返回条数", paramType = "query", dataType = "Integer"),
            @ApiImplicitParam(name = "organId", value = "统计机构", paramType = "query", dataType = "String")
    })
    @PostMapping("/getBoardProvincePlayTotalList")
    @RequiresPermissions("t:board:statistic:provPlayList")
    @ApiOperation(value = "获取省级展板播放统计", notes = "获取省级展板播放统计")
//    @MethodLog(operModule = OperModule.OVERVIEW, operType = OperType.SELECT)
    public Map<String, Object> getBoardProvincePlayTotalList(String organId) {

        List list = this.tBoardStatisticService.getBoardProvincePlayTotalList(organId);
        return getResult(list);
    }

    @ApiImplicitParams(value = {
            @ApiImplicitParam(name = "_index", value = "分页起始偏移量", paramType = "query", dataType = "Integer"),
            @ApiImplicitParam(name = "_size", value = "返回条数", paramType = "query", dataType = "Integer"),
            @ApiImplicitParam(name = "frequencyDate", value = "互动统计时间 年：yyyy 月：yyyyMM,默认当月", paramType = "query", dataType = "String")
    })
    @PostMapping("/getInteractionFrequencyPageList")
    @RequiresPermissions("t:board:statistic:districtPage")
    @ApiOperation(value = "获取互动频次统计信息", notes = "获取互动频次统计信息")
//    @MethodLog(operModule = OperModule.OVERVIEW, operType = OperType.SELECT)
    public Map<String, Object> getInteractionFrequencyPageList(String frequencyDate) {
        if (StringUtils.isEmpty(frequencyDate)){
            frequencyDate = DateUtil.getCurrentDate("yyyyMM");
        }

        Page page = this.tBoardStatisticService.getInteractionFrequency(getPage(),frequencyDate);
        //
        Map map = new HashMap();
        List organList = new ArrayList<>();
        List cntList = new ArrayList();
        for (Object o : page.getRecords()){
            Map m = (HashMap) o;
            organList.add(m.get("organName"));
            cntList.add(m.get("frequencyCnt"));
        }
        map.put("organList",organList);
        map.put("cntList",cntList);
        map.put("page",page);
        return getResult(map);
    }


    /**
     * 以下两个接口是为方便区分日志模块
     * @param trend
     * @return
     */
    @ApiImplicitParams(value = {
            @ApiImplicitParam(name = "_index", value = "分页起始偏移量", paramType = "query", dataType = "Integer"),
            @ApiImplicitParam(name = "_size", value = "返回条数", paramType = "query", dataType = "Integer")
    })
    @PostMapping("/getBoardPageList")
    @RequiresPermissions("t:board:statistic:Page")
    @ApiOperation(value = "获取展板播放趋势", notes = "获取展板播放趋势")
//    @MethodLog(operModule = OperModule.TEND, operType = OperType.SELECT)
    public Map<String, Object> getBoardPageList(TBoardPlayTrend trend) {
        // 如果查询日志为空，则默认当月
        if (StringUtils.isEmpty(trend.getPlayDate())){
            trend.setPlayDate(DateUtil.getCurrentDate("yyyyMM"));
        }

        Page<TBoardPlayTrend> page = this.tBoardStatisticService.getBoardTrendPageList(getPage(),trend);
        // 处理数据为展板趋势图
        Map map = new HashMap();
        List dateList = new ArrayList();
        List cntList = new ArrayList();
        for (TBoardPlayTrend t : page.getRecords()) {
            dateList.add(t.getPlayDate());
            cntList.add(t.getPlayNumber());
        }
        map.put("dateList",dateList);
        map.put("cntList",cntList);
        map.put("page",page);
        return getResult(map);
    }


    @ApiImplicitParams(value = {
            @ApiImplicitParam(name = "_index", value = "分页起始偏移量", paramType = "query", dataType = "Integer"),
            @ApiImplicitParam(name = "_size", value = "返回条数", paramType = "query", dataType = "Integer"),
            @ApiImplicitParam(name = "frequencyDate", value = "互动统计时间 年：yyyy 月：yyyyMM,默认当月", paramType = "query", dataType = "String")
    })
    @PostMapping("/getInteractionPageList")
    @RequiresPermissions("t:interaction:statistic:districtPage")
    @ApiOperation(value = "获取互动频次统计信息", notes = "获取互动频次统计信息")
//    @MethodLog(operModule = OperModule.INTERACTION, operType = OperType.SELECT)
    public Map<String, Object> getInteractionPageList(String frequencyDate) {
        if (StringUtils.isEmpty(frequencyDate)){
            frequencyDate = DateUtil.getCurrentDate("yyyyMM");
        }

        Page page = this.tBoardStatisticService.getInteractionFrequency(getPage(),frequencyDate);
        //
        Map map = new HashMap();
        List organList = new ArrayList<>();
        List cntList = new ArrayList();
        for (Object o : page.getRecords()){
            Map m = (HashMap) o;
            organList.add(m.get("organName"));
            cntList.add(m.get("frequencyCnt"));
        }
        map.put("organList",organList);
        map.put("cntList",cntList);
        map.put("page",page);
        return getResult(map);
    }
}

