package cn.wisenergy.chnmuseum.party.web.controller;

import cn.wisenergy.chnmuseum.party.common.log.MethodLog;
import cn.wisenergy.chnmuseum.party.common.log.OperModule;
import cn.wisenergy.chnmuseum.party.common.log.OperType;
import cn.wisenergy.chnmuseum.party.common.util.RSAUtils;
import cn.wisenergy.chnmuseum.party.model.TBoxOperation;
import cn.wisenergy.chnmuseum.party.model.TUser;
import cn.wisenergy.chnmuseum.party.service.TBoxOperationService;
import cn.wisenergy.chnmuseum.party.service.impl.TUserServiceImpl;
import cn.wisenergy.chnmuseum.party.web.controller.base.BaseController;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * <pre>
 * 机顶盒运维信息 前端控制器
 * </pre>
 *
 * @author Danny Lee
 * @since 2021-03-25
 */
@Slf4j
@RestController
@RequestMapping("/boxOperation")
@Api(tags = {"机顶盒运维信息操作接口"})
public class TBoxOperationController extends BaseController {

    @Resource
    private TBoxOperationService tBoxOperationService;

    @Resource
    private TUserServiceImpl userService;

    @ApiImplicitParams(value = {
            @ApiImplicitParam(name = "_index", value = "分页起始偏移量", paramType = "query", dataType = "Integer"),
            @ApiImplicitParam(name = "_size", value = "返回条数", paramType = "query", dataType = "Integer"),
            @ApiImplicitParam(name = "organId", value = "所属单位", paramType = "query", dataType = "String"),
            @ApiImplicitParam(name = "status", value = "状态 1.未激活 2.已激活 3.故障", paramType = "query", dataType = "Integer"),
            @ApiImplicitParam(name = "areaId", value = "区域", paramType = "query", dataType = "String")
    })
    @PostMapping("/selectPageList")
    @RequiresPermissions("/boxOperation/selectPageList")
    @ApiOperation(value = "获取机顶盒基础信息分页列表", notes = "获取机顶盒基础信息分页列表")
    @MethodLog(operModule = OperModule.STBBASE,operType = OperType.SELECT)
    public Map<String, Object> selectPageList(String organId, String areaId) {
        TUser user1 = getcurUser();
        TUser user = new TUser();
        if (StringUtils.isNotBlank(organId)) {
            user.setOrgId(organId);
        }
        if (StringUtils.isNotBlank(areaId)) {
            user.setAreaId(areaId);
        }
        //设置数据权限
//        if (StringUtils.isNotBlank(user1.getAreaId())) {
//            String areaId1 = getAreaId(user1.getAreaId());
//            user.setAreaName(areaId1);
//        }
        user.setOrgCode(user1.getOrgCode());
        try {
            Page<TBoxOperation> page = tBoxOperationService.selectBoxPage(getPage(), user);
            return getResult(page);
        } catch (Exception e) {
            e.printStackTrace();
        }
        return getFailResult();
    }

    @PostMapping("/add")
    @RequiresPermissions("/boxOperation/add")
    @ApiOperation(value = "添加机顶盒运维信息", notes = "添加机顶盒运维信息")
    @MethodLog(operModule = OperModule.STBOPERATION,operType = OperType.ADD)
    public Map<String, Object> saveTBoxOperation(TBoxOperation tBoxOperation) {
        // 保存业务节点信息
        boolean result;
        try {
            if (tBoxOperation != null && StringUtils.isNotBlank(tBoxOperation.getMac())) {
                tBoxOperation.setMac(tBoxOperation.getMac().toUpperCase());
            }
            final ArrayList<String> rsaKeys = RSAUtils.createRSAKeys();
            tBoxOperation.setPublicKey(rsaKeys.get(0));
            tBoxOperation.setPrivateKey(rsaKeys.get(1));
            result = tBoxOperationService.save(tBoxOperation);
            if (!result) {
                return getFailResult();
            }
            return getSuccessResult();
        } catch (Exception e) {
            e.printStackTrace();
        }
        // 保存失败
        return getFailResult();
    }

    @PutMapping("/update")
    @RequiresPermissions("/boxOperation/update")
    @ApiOperation(value = "修改机顶盒运维信息", notes = "修改机顶盒运维信息")
    @MethodLog(operModule = OperModule.STBOPERATION,operType = OperType.ACTIVATION)
    public Map<String, Object> updateTBoxOperation(TBoxOperation tBoxOperation) {
        try {
            if (tBoxOperation != null && StringUtils.isNotBlank(tBoxOperation.getMac())) {
                tBoxOperation.setMac(tBoxOperation.getMac().toUpperCase());
            }
            if (2==tBoxOperation.getStatus()) {
                final ArrayList<String> rsaKeys = RSAUtils.createRSAKeys();
                tBoxOperation.setPublicKey(rsaKeys.get(0));
                tBoxOperation.setPrivateKey(rsaKeys.get(1));
            }
            boolean flag = tBoxOperationService.updateById(tBoxOperation);
            UpdateWrapper<TUser> wrapper = new UpdateWrapper<>();
            wrapper.eq("org_id", tBoxOperation.getOrganId());
            wrapper.eq("type", "3");
            TUser user = userService.getOne(wrapper);
            String password = user.getPassword();
            if (flag) {
                return getResult(password);
            }
            return getFailResult();
        } catch (Exception e) {
            return getFailResult();
        }
    }

    @DeleteMapping("/delete")
    @RequiresPermissions("/boxOperation/delete")
    @ApiOperation(value = "根据ID删除机顶盒运维信息", notes = "根据ID删除机顶盒运维信息")
    @ApiImplicitParams(value = {
            @ApiImplicitParam(name = "id", value = "标识ID", paramType = "query", dataType = "String")
    })
    @MethodLog(operModule = OperModule.STBOPERATION,operType = OperType.DELETE)
    public Map<String, Object> deleteTBoxOperation(String id) {
        boolean result;
        try {
            result = tBoxOperationService.removeById(id);
            if (!result) {
                return getFailResult();
            }
            return getSuccessResult();
        } catch (Exception e) {
            e.printStackTrace();
        }
        return getFailResult();
    }

    @GetMapping("/getList")
    @RequiresPermissions("/boxOperation/getList")
    @ApiOperation(value = "获取机顶盒运维信息全部列表(无分页)", notes = "获取机顶盒运维信息全部列表(无分页)")
    @MethodLog(operModule = OperModule.STBOPERATION,operType = OperType.SELECT)
    public Map<String, Object> getTBoxOperationList(String status) {
        List<TBoxOperation> tBoxOperationList = null;
        TUser user = getcurUser();
        //设置数据权限
        String areaId = user.getAreaId();
        try {
            tBoxOperationList = tBoxOperationService.getList(status, getAreaId(areaId));
            return getResult(tBoxOperationList);
        } catch (Exception e) {
            e.printStackTrace();
        }
        return getFailResult();
    }

    @ApiImplicitParams(value = {
            @ApiImplicitParam(name = "_index", value = "分页起始偏移量", paramType = "query", dataType = "Integer"),
            @ApiImplicitParam(name = "_size", value = "返回条数", paramType = "query", dataType = "Integer"),
            @ApiImplicitParam(name = "organId", value = "所属单位", paramType = "query", dataType = "String"),
            @ApiImplicitParam(name = "status", value = "状态 1.未激活 2.已激活 3.故障", paramType = "query", dataType = "Integer"),
            @ApiImplicitParam(name = "areaId", value = "区域", paramType = "query", dataType = "String")
    })
    @PostMapping("/getPageList")
    @RequiresPermissions("/boxOperation/getPageList")
    @ApiOperation(value = "获取机顶盒运维信息分页列表", notes = "获取机顶盒运维信息分页列表")
    @MethodLog(operModule = OperModule.STBOPERATION,operType = OperType.SELECT)
    public Map<String, Object> getTBoxOperationPageList(String organId, Integer status, String areaId) {
        TUser user = getcurUser();
        TBoxOperation tBoxOperation = new TBoxOperation();
        if (StringUtils.isNotBlank(organId)) {
            tBoxOperation.setOrganId(organId);
        }
        if (status != null) {
            tBoxOperation.setStatus(status);
        }
        if (StringUtils.isNotBlank(areaId)) {
           tBoxOperation.setAreaId(areaId);
        }
        if (StringUtils.isNotBlank(user.getAreaId())) {
            //设置数据权限
            tBoxOperation.setAreaName(getAreaId(user.getAreaId()));
        }
        Page<TBoxOperation> page = null;
        try {
            page = this.tBoxOperationService.selectPage(getPage(), tBoxOperation);
            return getResult(page);
        } catch (Exception e) {
            e.printStackTrace();
        }
        return getFailResult();
    }

    @ApiOperation(value = "获取机顶盒运维信息详情", notes = "获取机顶盒运维信息详情")
    @GetMapping("/getById")
    @RequiresPermissions("/boxOperation/getById")
    @MethodLog(operModule = OperModule.STBOPERATION,operType = OperType.SELECT)
    public Map<String, Object> getById(@PathVariable("id") String id) {
        TBoxOperation tBoxOperation = null;
        try {
            tBoxOperation = tBoxOperationService.getById(id);
            return getResult(tBoxOperation);
        } catch (Exception e) {
            e.printStackTrace();
        }
        return getFailResult();
    }


    public static String getAreaId(String areaId) {
        if ("0000".equals(areaId.substring(2))) {
            areaId = areaId.substring(0, 2);
        } else if ("00".equals(areaId.substring(4))) {
            areaId = areaId.substring(0, 4);
        }
        return areaId;
    }

}

