package cn.wisenergy.chnmuseum.party.common.enums;

/**
 * 审核状态
 */
public enum AuditOperationEnum {

    ADD(1, "新增"),
    EDIT(2, "修改"),
    REMOVE(3, "删除"),
    DISABLE(4, "禁用/下架"),
    ENABLE(5, "启用/上架");

    // 错误编码
    private Integer code;
    // 信息
    private String operation;

    // 相应编码有参构造函数
    AuditOperationEnum(Integer code, String operation) {
        this.code = code;
        this.operation = operation;
    }

    public Integer getCode() {
        return code;
    }

    public void setCode(Integer code) {
        this.code = code;
    }

    public String getOperation() {
        return operation;
    }

    public void setOperation(String operation) {
        this.operation = operation;
    }

}
