package cn.wisenergy.chnmuseum.party.common.enums;

/**
 * 审核状态
 */
public enum AuditStatusEnum {

    TBC(1, "待初审"),
    REFUSED(2, "已驳回"),
    TBCA(3, "待复审"),
    APPROVED_FINAL(4, "通过");

    // 错误编码
    private Integer code;
    // 信息
    private String msg;

    // 相应编码有参构造函数
    AuditStatusEnum(Integer code, String msg) {
        this.code = code;
        this.msg = msg;
    }

    public Integer getCode() {
        return code;
    }

    public void setCode(Integer code) {
        this.code = code;
    }

    public String getMsg() {
        return msg;
    }

    public void setMsg(String msg) {
        this.msg = msg;
    }

}
