package cn.wisenergy.chnmuseum.party.common.enums;

import java.util.Arrays;
import java.util.stream.Collectors;

/**
 * 版权方类型枚举
 */
public enum CopyrightOwnerTypeEnum {

    VIDEO_CONTENT(1, "视频内容"),
    EXHIBITION_BOARD(2, "展板内容");
    public  String name;
    public static String names;

    // 错误编码
    private Integer code;
    // 信息
    private String type;

    CopyrightOwnerTypeEnum(Integer code, String type) {
        this.code = code;
        this.type = type;
    }

    public static String getName() {
        if (names == null) {
            names = Arrays.stream(CopyrightOwnerTypeEnum.values()).map(Enum::name).collect(Collectors.joining(","));
        }
        return names;
    }

    public Integer getCode() {
        return code;
    }

    public void setCode(Integer code) {
        this.code = code;
    }

    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }

}
