package cn.wisenergy.chnmuseum.party.common.enums;

/**
 * 响应编码
 */
public enum RESPONSE_CODE_ENUM {

    /* ******************** 系统异常 ********************* */
    PARAM_NOT_VALID("400", "请求的参数不合法"),
    RESOURCE_NOT_FOUND("404", "请求的资源不存在"),
    METHOD_NOT_SUPPORTED("405", "不支持的请求方法"),
    MEDIA_TYPE_NOT_ACCEPT("406", "无法接受请求中的媒体类型"),
    MEDIA_TYPE_NOT_SUPPORTED("415", "不支持的媒体类型"),
    SERVER_ERROR("500", "服务异常"),

    /* ******************** 业务自定义异常 **************** */
    REQUEST_PARAMS_ERROR("1001", "参数异常"),
    GAIN_DATA_FAIL("1003", "获取数据失败"),
    UPLOAD_FAILURE("1005", "上传失败"),
    AZKABAN_PROJECT_REPEAT("1006", "工程名重复"),

    HBASE_IOEXCEPTION("1008", "连接hbase异常"),
    CREATE_FLOW_PROJECT_ERROR("1009", "业务流程名称重复"),
    CREATE_FLOW_NODE_ERROR("1010", "业务节点名称重复"),

    FLUME_AGENT_ERROR("1011", "agent名称重复"),
    FLUME_AGENT_RUNNING("1012", "agent正在运行，不可操作"),
    PARAMETER_PARSING_FAILED("1013", "参数解析失败"),
    EMPTY_NODE_LIST_RUN_FAILED("1014", "节点集合为空，运行失败"),

    FLOW_RESOURCE_REPEAT("1015", "目录下，有重名资源"),
    FILE_SYSTEM_FILE_NOEXIST("1016", "目录不存在"),
    FILE_SYSTEM_FILE_EXCEPTION("1017", "访问异常"),
    EMPTY_NODE_RUN_FAILED("1018", "-节点内容为空"),
    EMPTY_NODE_LIST_SAVE_FAILED("1019", "节点集合为空，保存失败"),
    CANCEL_FLOW_CHAIN_FAILED("1020", "正在更新工作流程链，请稍后刷新页面"),

    TEMPORARY_QUERY_NAME_REPEAT("1021", "hive查询任务重名"),
    DATA_SYNC_NODE_CHECK_ERROR("1022", "数据同步节点配置错误"),

    HIVE_UPLOAD_FILE_INCORRECT("1028", "文件类型不支持"),

    SCHEDULE_FLOW_EXEC_REPEAT("1029", "业务流程的定时任务启动重复"),

    NAME_REPEAT("1030", "名称重复"),
    CODE_REPEAT("1031", "编码重复"),
    MODEL_RELEASE_ERROR("1032", "已为发布状态，不能发布"),
    MODEL_OFFLINE_ERROR("1033", "被占用，不能下线"),
    MODEL_DELETE_ERROR("1034", "发布状态，不能删除"),
    DIMENSION_TABLE_DATABASE_INFO_ERROR("1035", "维度表数据源信息是必须的"),
    DIMENSION_TABLE_CREATE_TABLE_ERROR("1036", "维度表创建失败"),
    FACT_ATTRIBUTES_CHECK_ERROR("1037", "事实表属性必须包含时间数据类型"),
    FACT_TABLES_CREATE_TABLE_ERROR("1038", "事实表创建失败"),
    FACT_TABLES_DATABASE_INFO_ERROR("1039", "事实表数据源信息是必须的"),
    AGGREGATION_TABLE_DATABASE_INFO_ERROR("1040", "汇总表数据源信息是必须的"),
    AGGREGATION_TABLE_CREATE_TABLE_ERROR("1041", "汇总表创建失败"),
    AGGREGATION_ATTRIBUTES_CHECK_ERROR("1042", "汇总表必须配置时间周期和指标"),
    MODEL_CREATE_ERROR("1043", "创建失败"),
    MODEL_OFFLINE_STATUS_ERROR("1044", "当前状态为非发布状态，不允许下线"),
    FIELD_NAME_ID_REPEAT_ERROR("1045", "字段名称id不允许重复"),

    ASSET_LABEL_DELETE_ERROR("1046", "标签为引用状态,不能删除"),

    QUALITY_JOB_NOT_EXIST("1047", "质量作业不存在"),
    SYSTEM_TEMPLATE_NOT_OPERATIONAL_ERROR("1048", "系统模板不可操作"),
    QUALITY_JOB_RUNNING_NOT_DELETE("1049", "质量作业正在运行，不能删除"),
    QUALITY_RULE_SQL_SEMANTIC_VERIFICATION_ERROR("1050", "语义校验失败，请检查。"),
    QUALITY_JOB_PERIOD_CRON_NOT_EXIST("1051", "CRON表达式不存在"),
    QUALITY_JOB_RUN_TASK_NOT_FIND("1052", "找不到要停止的质量作业任务"),
    OUTPUT_SHOW_WITH_SQL_NOT_MATCH_ERROR("1053", "输出结果说明与定义关系不匹配"),
    LACK_A_PRIMARY_KEY_ERROR("1054", "至少包含一个主键属性"),
    QUALITY_JOB_RUN_ERROR("1055", "启动质量作业失败，请检查质量作业参数..."),

    ILLEGAL_OPERATION("1400", "违规操作"),

    BUSINESS_OBJECT_NAME_REGEX_CHECK_ERROR("1500", "只允许除右斜杠、<、>、/外的字符"),

    /* ******************** 登录权限 **************** */
    USER_NAME_REPEAT("1101", "账户已存在"),
    LOGIN_INCORRECT("1102", "登录异常"),
    LOGIN_NOT_EXISTS("1103", "账户不存在"),
    LOGIN_PWD_INCORRECT("1104", "账户或密码不正确"),
    NOT_LOGIN_ERROR("1105", "重新登录"),
    OLD_PASSWORD_INCORRECT("1106", "旧密码不正确"),

    ACCOUNT_HAS_BEEN_DISABLED("1107", "此账号已被禁用"),
    ACCOUNT_IS_LOCKED("1108", "此账号已被锁定，请稍后再试"),
    ACCOUNT_AUTHENTICATION_FAILED("1109", "账号认证失败"),
    UNAUTHORIZED("1110", "权限不足"),
    ROLE_CODE_REPEAT("1111", "角色编码已存在"),
    SYS_ROLE_DELETE_FAIL("1112", "系统角色不允许删除"),
    SYS_MENU_DELETE_FAIL("1113", "还存在子菜单，不能直接删除"),
    /* ******************** 操作失败 **************** */
    REQUEST_FAIL("1100", "操作失败"),
    /* ******************** 操作成功 **************** */
    REQUEST_SUCCESS("200", "操作成功");


    // 错误编码
    private String resultCode;

    // 错误信息
    private String message;

    // 相应编码有参构造函数


    RESPONSE_CODE_ENUM(String resultCode, String message) {
        this.resultCode = resultCode;
        this.message = message;
    }

    public String getResultCode() {
        return resultCode;
    }

    public String getMessage() {
        return message;
    }

    public void setResultCode(String resultCode) {
        this.resultCode = resultCode;
    }

    public void setMessage(String message) {
        this.message = message;
    }
}
