package cn.wisenergy.chnmuseum.party.common.multidatasource;

import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.annotation.Pointcut;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 *  这是为了保证AOP在事务注解之前生效,Order的值越小,优先级越高
 */
//@Order(-100)
//@Component
//@Aspect
public class DataSourceSwitchAspect {

    private static final Logger LOGGER = LoggerFactory.getLogger(DataSourceSwitchAspect.class);

    @Pointcut("execution(* cn.gov.zunyi.business.hall.mapper.db1..*.*(..))")
    private void db1Aspect() {
    }

    @Pointcut("execution(* cn.gov.zunyi.business.hall.mapper.db2..*.*(..))")
    private void db2Aspect() {
    }

    @Before("db1Aspect()")
    public void db1() {
        LOGGER.info("切换到db1 数据源...");
        DbContextHolder.setDbType(DBTypeEnum.datasource1);
    }

    @Before("db2Aspect()")
    public void db2 () {
        LOGGER.info("切换到db2 数据源...");
        DbContextHolder.setDbType(DBTypeEnum.datasource2);
    }

}
