package cn.wisenergy.chnmuseum.party.common.multidatasource;

import org.springframework.jdbc.datasource.lookup.AbstractRoutingDataSource;

public class DynamicMultipleDataSource extends AbstractRoutingDataSource {

    @Override
    protected Object determineCurrentLookupKey() {
        String lookupKey = DbContextHolder.getDbType();
        if(lookupKey == null) {
            lookupKey = DBTypeEnum.datasource2.toString();
        }
        DbContextHolder.clearDbType();
        return lookupKey;
    }
}
