package cn.wisenergy.chnmuseum.party.common.mvc;

import cn.wisenergy.chnmuseum.party.common.util.DateUtil;
import org.apache.commons.lang3.StringUtils;
import org.springframework.core.convert.converter.Converter;

import java.time.LocalDate;

/**
 * @author Danny Lee
 * @since 2019-05-31 13:39
 */
public class StringToLocalDateConverter implements Converter<String, LocalDate> {

    @Override
    public LocalDate convert(String source) {
        if (StringUtils.isEmpty(source)) {
            return null;
        }
        return DateUtil.parseStringToDate(source, DateUtil.LONG_DATE_FORMAT);
    }

}
