package cn.wisenergy.chnmuseum.party.common.mvc;

import cn.wisenergy.chnmuseum.party.common.util.DateUtil;
import org.apache.commons.lang3.StringUtils;
import org.springframework.core.convert.converter.Converter;

import java.time.LocalDateTime;

/**
 * @author Danny Lee
 * @since 2019-05-31 13:39
 */
public class StringToLocalDateTimeConverter implements Converter<String, LocalDateTime> {

    @Override
    public LocalDateTime convert(String source) {
        if (StringUtils.isEmpty(source)) {
            return null;
        }
        return DateUtil.parseStringToDateTime(source, DateUtil.FORMAT_ONE);
    }

}
