package cn.wisenergy.chnmuseum.party.common.mvc;

import cn.wisenergy.chnmuseum.party.common.util.DateUtil;
import org.apache.commons.lang3.StringUtils;
import org.springframework.core.convert.converter.Converter;

import java.time.LocalTime;

/**
 * @author Danny Lee
 * @since 2019-05-31 13:39
 */
public class StringToLocalTimeConverter implements Converter<String, LocalTime> {

    @Override
    public LocalTime convert(String source) {
        if (StringUtils.isEmpty(source)) {
            return null;
        }
        return DateUtil.parseStringToTime(source, DateUtil.SHORT_TIME_FORMAT);
    }

}
