package cn.wisenergy.chnmuseum.party.common.mybatis;

import com.baomidou.mybatisplus.annotation.DbType;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.core.toolkit.StringPool;
import com.baomidou.mybatisplus.generator.AutoGenerator;
import com.baomidou.mybatisplus.generator.InjectionConfig;
import com.baomidou.mybatisplus.generator.config.*;
import com.baomidou.mybatisplus.generator.config.po.TableFill;
import com.baomidou.mybatisplus.generator.config.po.TableInfo;
import com.baomidou.mybatisplus.generator.config.rules.DateType;
import com.baomidou.mybatisplus.generator.config.rules.NamingStrategy;
import org.apache.commons.lang3.StringUtils;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CodeGenerator {

    // ############################ 自定义配置部分 start ############################
    /**
     * 框架包
     */
    private static final String FRAMEWORK_PACKAGE = "cn.wisenergy.chnmuseum.party";
    /**
     * 生成的类路径
     */
    private String projectPackagePath;
    /**
     * 项目主包路径
     */
    private String parentPackage;
    /**
     * 包名称
     */
    private String packageController = "controller";
    /**
     * 模块名称
     */
    private String moduleName;
    /**
     * 作者
     */
    private String author;
    /**
     * 主键数据库列名称
     */
    private String pkIdColumnName = "ID";
    /**
     * 代码生成策略 true：All/false:SIMPLE
     * 0. SIMPLE 生成最基本的代码
     * 1. NORMAL 生成普通代码
     * 2. ALL 生成所有的代码
     */
    private GeneratorStrategy generatorStrategy = GeneratorStrategy.NORMAL;

    /**
     * 生成策略
     */
    public enum GeneratorStrategy {
        SIMPLE, NORMAL, ALL
    }

    /**
     * 分页列表查询是否排序 true：有排序参数/false：无
     */
    private boolean pageListOrder = false;
    /**
     * 是否生成validation校验，true：生成/false：不生成
     */
    private boolean paramValidation = true;
    /**
     * 是否生成查询参数
     */
    private boolean generatorPageParam;
    /**
     * 是否生成查询VO
     */
    private boolean generatorQueryVo;
    /**
     * 是否生成Shiro RequiresPermissions 注解
     */
    private boolean requiresPermissions = true;
    /**
     * 公共父包
     */
    private String commonParentPackage;
    /**
     * 分页查询参数父类
     */
    private String superPageParam;
    /**
     * 分页排序查询参数父类
     */
    private String superPageOrderParam;
    /**
     * 分页工具类路径
     */
    private String commonPageUtil;
    /**
     * 实体父类实体列表
     */
    private String[] superEntityCommonColumns;
    /**
     * 公共id参数路径
     */
    private String commonIdParam;
    /**
     * 公共结果集路径
     */
    private String commonApiResult;
    /**
     * 公共排序枚举
     */
    private String commonOrderEnum;
    /**
     * 公共排序查询参数
     */
    private String commonOrderPageParam;
    /**
     * 公共分页对象
     */
    private String commonPaging;
    // ############################ 自定义配置部分 end ############################

    /**
     * 初始化变量
     */
    public void init() {
        this.commonParentPackage = FRAMEWORK_PACKAGE + ".common";
        this.superPageParam = this.commonParentPackage + ".pagination.BasePageParam";
        this.superPageOrderParam = FRAMEWORK_PACKAGE + ".pagination.BasePageOrderParam";
        this.superEntityCommonColumns = new String[]{};

        // 公共类包路径
        this.commonIdParam = this.commonParentPackage + ".param.IdParam";
        this.commonApiResult = this.commonParentPackage + ".api.ApiResult";
        this.commonOrderEnum = this.commonParentPackage + ".enums.OrderEnum";
        this.commonPaging = FRAMEWORK_PACKAGE + ".pagination.Paging";
        this.commonPageUtil = FRAMEWORK_PACKAGE + ".pagination.PageUtil";

        // 如果包路径为空，转换包名称路径
        if (StringUtils.isNotBlank(parentPackage)) {
            this.projectPackagePath = parentPackage.replaceAll("\\.", File.separator);
        }
    }

    /**
     * <p>
     * MySQL 生成演示
     * </p>
     */
    public void generator(String projectPath, String tableName) {
        // 全局配置
        GlobalConfig gc = new GlobalConfig();
        gc.setOutputDir(projectPath + "/src/main/java");
        gc.setIdType(IdType.ASSIGN_ID);
        gc.setBaseResultMap(true);
        gc.setBaseColumnList(true);
        gc.setFileOverride(true);
        gc.setDateType(DateType.TIME_PACK);
        // 不需要ActiveRecord特性的请改为false
        gc.setActiveRecord(false);
        gc.setSwagger2(true);
        // 是否生成 kotlin 代码
        gc.setKotlin(false);
        // XML 二级缓存
        gc.setEnableCache(false);
        gc.setAuthor("Danny Lee");
        gc.setOpen(false);

        // 自定义文件命名，注意 %s 会自动填充表实体属性！
//        gc.setEntityName("%s");
        gc.setServiceName("%sService");
        gc.setServiceImplName("%sServiceImpl");
        gc.setMapperName("%sMapper");
        gc.setXmlName("%sMapper");
        gc.setControllerName("%sController");

        // 数据源配置
        DataSourceConfig dsc = new DataSourceConfig();
        dsc.setDbType(DbType.MYSQL);
        dsc.setUrl("jdbc:mysql://192.168.110.93:3306/chnmuseum-party?autoReconnect=true&useUnicode=true&characterEncoding=utf8&zeroDateTimeBehavior=CONVERT_TO_NULL&allowMultiQueries=true&useSSL=false&serverTimezone=Asia/Shanghai");
        dsc.setDriverName("com.mysql.cj.jdbc.Driver");
        dsc.setUsername("root");
        dsc.setPassword("password");
        // 设置元数据自定义查询
        dsc.setDbQuery(new MySQLQuery());

        // 包配置
        PackageConfig pc = new PackageConfig();
        pc.setModuleName("party");
        pc.setParent("cn.wisenergy.chnmuseum")
                .setMapper("mapper")
                .setService("service")
                .setServiceImpl("service.impl")
                .setController("web.controller")
                .setEntity("model")
                .setXml("mapper");

        // 自定义需要填充的字段 数据库中的字段
        List<TableFill> tableFillList = new ArrayList<>();
        tableFillList.add(new TableFill("CREATE_TIME", FieldFill.INSERT));
        tableFillList.add(new TableFill("UPDATE_TIME", FieldFill.INSERT_UPDATE));
        tableFillList.add(new TableFill("VERSION", FieldFill.INSERT));

        // 策略配置
        StrategyConfig sc = new StrategyConfig();
        //驼峰命名
        sc.setCapitalMode(true);
        //实体类是否带有lombok风格
        sc.setEntityLombokModel(true);
        //允许字段自动注解
        sc.setEntityTableFieldAnnotationEnable(true);
        sc.isEntityTableFieldAnnotationEnable();
        //rest风格controller
        sc.setRestControllerStyle(true);
        //路径加分隔符
        sc.setControllerMappingHyphenStyle(true);
        sc.setVersionFieldName(GeneratorConstant.VERSION);
        sc.setLogicDeleteFieldName(GeneratorConstant.DELETED);

//        sc.setTablePrefix("M_");//表前缀
        // 表名生成策略(下划线转驼峰命名)
        sc.setNaming(NamingStrategy.underline_to_camel);
        // 列名生成策略(下划线转驼峰命名)
        sc.setColumnNaming(NamingStrategy.underline_to_camel);
        // 自定义controller父类
        sc.setSuperControllerClass("cn.wisenergy.chnmuseum.party.web.controller.base.BaseController");
        //strategy.setSuperEntityColumns("id");//自定义基础的Entity类，公共字段
        //自动填充设置
        sc.setTableFillList(tableFillList);
        //修改替换成你需要的表名，多个表名传数组，允许正则表达式(与exclude二选一配置)
        sc.setInclude(tableName);

        InjectionConfig injectionConfig = new InjectionConfig() {
            @Override
            public void initMap() {
//                Set<String> tablePrefixSet = this.getConfig().getStrategyConfig().getInclude();
                String entityName = tableName;
                String camelTableName = underlineToCamel(entityName);
                String pascalTableName = underlineToPascal(entityName);
                String colonTableName = underlineToColon(entityName);

                Map<String, Object> map = new HashMap<>();
                map.put("abc", this.getConfig().getGlobalConfig().getAuthor() + "-mp");

                // 查询参数包路径
                String paramPackage = parentPackage + StringPool.DOT + pc.getModuleName() + ".param";
                map.put("paramPackage", paramPackage);
                // 查询参数类路径
                map.put("pageParamPath", paramPackage + StringPool.DOT + pascalTableName + "PageParam");
                // 查询参数共公包路径
                map.put("superPageParamPath", superPageParam);
                map.put("superPageOrderParamPath", superPageOrderParam);
                map.put("commonPageUtilPath", commonPageUtil);
                // 查询参数共公包路径
                map.put("idParamPath", commonIdParam);
                // 响应结果包路径
                String queryVoPackage = parentPackage + StringPool.DOT + pc.getModuleName() + ".vo";
                map.put("queryVoPackage", queryVoPackage);
                // 响应结果类路径
                map.put("queryVoPath", queryVoPackage + StringPool.DOT + pascalTableName + "QueryVo");
                // 实体对象名称
                map.put("entityObjectName", camelTableName);
                // service对象名称
                map.put("serviceObjectName", camelTableName + "Service");
                // mapper对象名称
                map.put("mapperObjectName", camelTableName + "Mapper");
                // 主键ID列名
                map.put("pkIdColumnName", pkIdColumnName);
                // 主键ID驼峰名称
                map.put("pkIdCamelName", underlineToCamel(pkIdColumnName));
                // 导入分页类
                map.put("paging", commonPaging);
                // 导入排序枚举
                map.put("orderEnum", commonOrderEnum);
                // ApiResult
                map.put("apiResult", commonApiResult);
                // 分页列表查询是否排序
                map.put("pageListOrder", pageListOrder);
                // 导入排序查询参数类
                map.put("orderPageParamPath", commonOrderPageParam);
                // 代码生成策略
                map.put("generatorStrategy", generatorStrategy);
                // 代码Validation校验
                map.put("paramValidation", paramValidation);
                // 冒号连接的表名称
                map.put("colonTableName", colonTableName);
                // 是否生成Shiro RequiresPermissions注解
                map.put("requiresPermissions", requiresPermissions);

                this.setMap(map);
            }
        };
        List<FileOutConfig> focList = new ArrayList<>();
        focList.add(new FileOutConfig("/templates/mapper.xml.vm") {
            @Override
            public String outputFile(TableInfo tableInfo) {
                return projectPath + "/src/main/resources/mapper/" + tableInfo.getEntityName() + "Mapper" + StringPool.DOT_XML;
            }
        });
        focList.add(new FileOutConfig("/templates/controller.java.vm") {
            @Override
            public String outputFile(TableInfo tableInfo) {
                return projectPath + "/src/main/java/cn/wisenergy/chnmuseum/party/web/controller/" + tableInfo.getEntityName() + "Controller" + StringPool.DOT_JAVA;
            }
        });
        injectionConfig.setFileOutConfigList(focList);

        TemplateConfig templateConfig = new TemplateConfig();
        templateConfig.setController(null);
        templateConfig.setXml(null);
        templateConfig.setEntity("/templates/entity.java.vm");

        new AutoGenerator()
                .setGlobalConfig(gc)
                .setDataSource(dsc)
                .setCfg(injectionConfig)
                .setPackageInfo(pc)
                .setStrategy(sc)
                .setTemplate(templateConfig)
                .execute();
    }

    /**
     * 下划线专程驼峰命名
     * sys_user --> sysUser
     *
     * @param underline
     * @return
     */
    public static String underlineToCamel(String underline) {
        if (StringUtils.isNotBlank(underline)) {
            return NamingStrategy.underlineToCamel(underline);
        }
        return null;
    }

    /**
     * 下划线转换成帕斯卡命名
     * sys_user --> SysUser
     *
     * @param underline
     * @return
     */
    public static String underlineToPascal(String underline) {
        if (StringUtils.isNotBlank(underline)) {
            return NamingStrategy.capitalFirst(NamingStrategy.underlineToCamel(underline));
        }
        return null;
    }

    /**
     * 下划线转换成冒号连接命名
     * sys_user --> sys:user
     *
     * @param underline
     * @return
     */
    public static String underlineToColon(String underline) {
        if (StringUtils.isNotBlank(underline)) {
            String string = underline.toLowerCase();
            return string.replaceAll("_", ":");
        }
        return null;
    }

}
