package cn.wisenergy.chnmuseum.party.common.mybatis;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.toolkit.Constants;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.conditions.query.QueryChainWrapper;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.baomidou.mybatisplus.extension.conditions.update.UpdateChainWrapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 自定义BaseMapper，增加了批量增删改查的方法
 *
 * @author Danny Lee
 * @since 2020年4月2日15:34:17
 */
public interface MyBaseMapper<T> extends BaseMapper<T> {

    /**
     * 以下定义的 4个 method，其中前3个是mybatisPlus内置的选装件（升级到3.3之后才有的），如果要自动填充，@{@code Param}(xx) xx参数名必须是 list/collection/array 3个的其中之一
     * <p>
     * 批量插入
     */
    int insertBatchSomeColumn(@Param("list") List<T> list);

    /**
     * 批量更新
     */
    int alwaysUpdateSomeColumnById(@Param(Constants.ENTITY) T entity);

    /**
     * 批量删除
     */
    int deleteByIdWithFill(T entity);

    /**
     * n
     * 以下定义的 4个 default method,
     * copy from {@link com.baomidou.mybatisplus.extension.toolkit.ChainWrappers}
     */
    default QueryChainWrapper<T> queryChain() {
        return new QueryChainWrapper<>(this);
    }

    default LambdaQueryChainWrapper<T> lambdaQueryChain() {
        return new LambdaQueryChainWrapper<>(this);
    }

    default UpdateChainWrapper<T> updateChain() {
        return new UpdateChainWrapper<>(this);
    }

    default LambdaUpdateChainWrapper<T> lambdaUpdateChain() {
        return new LambdaUpdateChainWrapper<>(this);
    }

    //以下为自己自定义method
    int insertBatch(@Param("list") List<T> list);

}
