package cn.wisenergy.chnmuseum.party.common.util;

import java.math.BigDecimal;
import java.text.DecimalFormat;

public class CurrencyMathUtil {
    private static int SCALE = 18;

    public static int compare(String str1, String str2) {
        BigDecimal a = new BigDecimal(str1).setScale(SCALE, BigDecimal.ROUND_HALF_DOWN);
        BigDecimal b = new BigDecimal(str2).setScale(SCALE, BigDecimal.ROUND_HALF_DOWN);
        return a.compareTo(b);
    }

    /**
     * 乘法
     * @param str1
     * @param str2
     * @return
     */
    public static String multiply(String str1, String str2) {
        BigDecimal a = new BigDecimal(str1).setScale(SCALE, BigDecimal.ROUND_HALF_DOWN);
        BigDecimal b = new BigDecimal(str2).setScale(SCALE, BigDecimal.ROUND_HALF_DOWN);
        BigDecimal c = a.multiply(b).setScale(SCALE, BigDecimal.ROUND_HALF_DOWN);
        return c.stripTrailingZeros().toPlainString();
    }

    /**
     * 除法
     * @param str1
     * @param str2
     * @return
     */
    public static String divide(String str1, String str2) {
        BigDecimal a = new BigDecimal(str1).setScale(SCALE, BigDecimal.ROUND_HALF_DOWN);
        BigDecimal b = new BigDecimal(str2).setScale(SCALE, BigDecimal.ROUND_HALF_DOWN);
        BigDecimal c = a.divide(b, SCALE, BigDecimal.ROUND_HALF_DOWN);
        return c.stripTrailingZeros().toPlainString();
    }

    /**
     * 加法
     * @param str1
     * @param str2
     * @return
     */
    public static String add(String str1, String str2) {
        BigDecimal a = new BigDecimal(str1).setScale(SCALE, BigDecimal.ROUND_HALF_DOWN);
        BigDecimal b = new BigDecimal(str2).setScale(SCALE, BigDecimal.ROUND_HALF_DOWN);
        BigDecimal c = a.add(b).setScale(SCALE, BigDecimal.ROUND_HALF_DOWN);
        return c.stripTrailingZeros().toPlainString();
    }

    public static String add(Integer str1, Integer str2) {
        BigDecimal a = new BigDecimal(str1.toString()).setScale(SCALE, BigDecimal.ROUND_HALF_DOWN);
        BigDecimal b = new BigDecimal(str2.toString()).setScale(SCALE, BigDecimal.ROUND_HALF_DOWN);
        BigDecimal c = a.add(b).setScale(SCALE, BigDecimal.ROUND_HALF_DOWN);
        return c.stripTrailingZeros().toPlainString();
    }

    public static Double add(Double d1, Double d2) {
        BigDecimal a = new BigDecimal(d1.toString()).setScale(SCALE, BigDecimal.ROUND_HALF_DOWN);
        BigDecimal b = new BigDecimal(d2.toString()).setScale(SCALE, BigDecimal.ROUND_HALF_DOWN);
        BigDecimal c = a.add(b).setScale(SCALE, BigDecimal.ROUND_HALF_DOWN);
        return c.stripTrailingZeros().doubleValue();
    }


    /**
     * 减法
     * @param str1
     * @param str2
     * @return
     */
    public static String subtract(String str1, String str2) {
        BigDecimal a = new BigDecimal(str1).setScale(SCALE, BigDecimal.ROUND_HALF_DOWN);
        BigDecimal b = new BigDecimal(str2).setScale(SCALE, BigDecimal.ROUND_HALF_DOWN);
        BigDecimal c = a.subtract(b).setScale(SCALE, BigDecimal.ROUND_HALF_DOWN);
        return c.stripTrailingZeros().toPlainString();
    }

    public static Double subtract(Double str1, Double str2) {
        BigDecimal a = new BigDecimal(str1.toString()).setScale(SCALE, BigDecimal.ROUND_HALF_DOWN);
        BigDecimal b = new BigDecimal(str2.toString()).setScale(SCALE, BigDecimal.ROUND_HALF_DOWN);
        BigDecimal c = a.subtract(b).setScale(SCALE, BigDecimal.ROUND_HALF_DOWN);
        return c.stripTrailingZeros().doubleValue();
    }

    public static String gweiToWei(String gwei) {
        BigDecimal a = new BigDecimal(gwei).setScale(SCALE, BigDecimal.ROUND_HALF_DOWN);
        BigDecimal b = new BigDecimal("1000000000").setScale(SCALE, BigDecimal.ROUND_HALF_DOWN);
        BigDecimal c = a.multiply(b).setScale(SCALE, BigDecimal.ROUND_HALF_DOWN);
        return c.stripTrailingZeros().toPlainString();
    }

    public static String ethToWei(String eth) {
        BigDecimal a = new BigDecimal(eth).setScale(SCALE, BigDecimal.ROUND_HALF_DOWN);
        BigDecimal b = new BigDecimal("1000000000000000000").setScale(SCALE, BigDecimal.ROUND_HALF_DOWN);
        BigDecimal c = a.multiply(b).setScale(SCALE, BigDecimal.ROUND_HALF_DOWN);
        return c.stripTrailingZeros().toPlainString();
    }

    public static String ethToGwei(String eth) {
        BigDecimal a = new BigDecimal(eth).setScale(SCALE, BigDecimal.ROUND_HALF_DOWN);
        BigDecimal b = new BigDecimal("1000000000").setScale(SCALE, BigDecimal.ROUND_HALF_DOWN);
        BigDecimal c = a.multiply(b).setScale(SCALE, BigDecimal.ROUND_HALF_DOWN);
        return c.stripTrailingZeros().toPlainString();
    }

    public static String gweiToEth(String gwei) {
        BigDecimal a = new BigDecimal(gwei).setScale(SCALE, BigDecimal.ROUND_HALF_DOWN);
        BigDecimal b = new BigDecimal("1000000000").setScale(SCALE, BigDecimal.ROUND_HALF_DOWN);
        BigDecimal c = a.divide(b).setScale(SCALE, BigDecimal.ROUND_HALF_DOWN);
        return c.stripTrailingZeros().toPlainString();
    }

    public static String weiToEth(String gwei) {
        BigDecimal a = new BigDecimal(gwei).setScale(SCALE, BigDecimal.ROUND_HALF_DOWN);
        BigDecimal b = new BigDecimal("1000000000000000000").setScale(SCALE, BigDecimal.ROUND_HALF_DOWN);
        BigDecimal c = a.divide(b).setScale(SCALE, BigDecimal.ROUND_HALF_DOWN);
        return c.stripTrailingZeros().toPlainString();
    }

    public static String roundByScale(double v, int scale) {
        if (scale < 0) {
            throw new IllegalArgumentException(
                    "The scale must be a positive integer or zero");
        }
        if (scale == 0) {
            return new DecimalFormat("0").format(v);
        }
        String formatStr = "0.";
        for (int i = 0; i < scale; i++) {
            formatStr = formatStr + "0";
        }
        return new DecimalFormat(formatStr).format(v);
    }
}
