package cn.wisenergy.chnmuseum.party.common.util;

import com.alibaba.fastjson.serializer.JSONSerializer;
import com.alibaba.fastjson.serializer.ObjectSerializer;

import java.lang.reflect.Type;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;

public class MyLocalDateSerializer implements ObjectSerializer {

    private final String pattern;

    public MyLocalDateSerializer(String pattern) {
        this.pattern = pattern;
    }

    @Override
    public void write(JSONSerializer jsonSerializer, Object object, Object fieldName, Type fieldType, int i) {
        if (object == null) {
            jsonSerializer.out.writeNull();
            return;
        }
        if (object instanceof LocalDate) {
            LocalDate localDate = (LocalDate) object;
            String format = localDate.format(DateTimeFormatter.ofPattern(pattern));
            jsonSerializer.write(format);
        }
    }

}
