package cn.wisenergy.chnmuseum.party.common.util;

import com.alibaba.fastjson.serializer.JSONSerializer;
import com.alibaba.fastjson.serializer.ObjectSerializer;

import java.lang.reflect.Type;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;

public class MyLocalDateTimeSerializer implements ObjectSerializer {

    private final String pattern;

    public MyLocalDateTimeSerializer(String pattern) {
        this.pattern = pattern;
    }

    @Override
    public void write(JSONSerializer jsonSerializer, Object object, Object fieldName, Type fieldType, int i) {
        if (object == null) {
            jsonSerializer.out.writeNull();
            return;
        }
        if (object instanceof LocalDateTime) {
            LocalDateTime localDateTime = (LocalDateTime) object;
            String format = localDateTime.format(DateTimeFormatter.ofPattern(pattern));
            jsonSerializer.write(format);
        }
    }

}
