package cn.wisenergy.chnmuseum.party.common.util;

import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.Signature;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.Base64;

public class SignUtils {

    private static final String ALGORITHM = "RSA";

    private static final String SIGN_SHA256RSA_ALGORITHMS = "SHA256WithRSA";

    private static final String DEFAULT_CHARSET = "UTF-8";

    private final static String PUBLIC_KEY_NAME = "MIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAsTVgqPjswjCKU7kjOfZO/jB1Oiz3zrW0kLfjBiRXHnXrm3Br4cgpA78snK/isaVykOBJYL549JkgHqTo17RSdqdS2i0rjzEUtKEotSpoP9XzNxt3ufKSq1MxBU5ZVuJTJ4Juat9RKcgNvhTc5NYMjF7PsBrrqPolgOd9Y5VyMaNRch+3owlDNzck0zWXAWas8KNJuV68ZH6hqu0Lb0QfrWETkm4o3ah7A1ss/UB//XSg0wipMa2em9WI6hUxW87JKR3W63dx89q9aP589UeE5XpamDhr1fglIpzeS/SdA61cY4K5v9v+mGxI3jePc6RSETvwc8P68/XNViSgT+uJAwIDAQAB";
    private final static String PRIVATE_KEY_NAME = "MIIEvAIBADANBgkqhkiG9w0BAQEFAASCBKYwggSiAgEAAoIBAQCxNWCo+OzCMIpTuSM59k7+MHU6LPfOtbSQt+MGJFcedeubcGvhyCkDvyycr+KxpXKQ4Elgvnj0mSAepOjXtFJ2p1LaLSuPMRS0oSi1Kmg/1fM3G3e58pKrUzEFTllW4lMngm5q31EpyA2+FNzk1gyMXs+wGuuo+iWA531jlXIxo1FyH7ejCUM3NyTTNZcBZqzwo0m5XrxkfqGq7QtvRB+tYROSbijdqHsDWyz9QH/9dKDTCKkxrZ6b1YjqFTFbzskpHdbrd3Hz2r1o/nz1R4TlelqYOGvV+CUinN5L9J0DrVxjgrm/2/6YbEjeN49zpFIRO/Bzw/rz9c1WJKBP64kDAgMBAAECggEAKf9ohSNZmTw/zE/YVWhWmE+LuNnncQoHXTT3jQEX1JRF3nTqXHw/nC+2tvvIUinP2R4OxereZ7nSrvCObnDCCnTlYefKpwkOyzBWoXkHc/mUxr6vxVYEBK6Ws5c5/SluY7K50IJUjf5no2D2aRWBq9LcjfQTXdzK/p3eTbehdLnHITIilY699lN0CIwPpvNjAIOwYzyoqI7xQ8S5bopl1A1gKK7MN9EQb6aqn7kNSQCkwRq+1dETlZpfl7He4Fc4Q7brEQf7Qzdk2s2ddnlOU8Q4An4A+m2NMow0abe7g1EnVlw4cag0E6/tbC21Hy6Oa/LpZmRMiZU4iuo/PvSYYQKBgQDXJUiM0ILUqGcv6FbKFEu6MjT2JgClK2xiMFv8MKPyDth+XxjhvqV1FKMVNXkdrtR8lw3qnTquaxqor4IQMLsZa775H2zefYuqiOnFD9W4NpjwxG7yWhtbpSgWIQSHXVDO6mIR6Qh0lAUk4AYwjEae1auZgBoM5YsKMxN7PFDUHwKBgQDS2+Jg9GP1j8cmO14J/f+wBqTme1oz4bkES9tGcFapdVdlkPf5ahVH+yDhrgGVCcO2w6sam06WrmxV4H4OV5wl94hr36NC6S2lmIIF9DuX21cZandWI5vJr6umxrlo3f5+tpSC9Ekgd7Yro44+DohlMrUbAFwm6+hSIin210hOnQKBgFMJEr02ZKhK7rhwxb5souWUJxixhiI5ZjVnULk+1KfBzxDHB0VpXVaYxnCTGNG5/kyvyDE6ycEzmTBtvJcfF7cx/J0N4ejlL5h8Cy2BdQ0KFXEnf2KOIGz4i0YvLB5Kh7u0fnFHLXpA/tNCm2D1YvQ+p2IxLNy5YzZmjChOGSwlAoGAYAyTYTDR+8DDqbGvU4PlHazZHrgfzbRLkB5xwvNXNpfh+L0BiBZ/nStSvhqCU/5/rVgSL+uA7/iCFthM84GK+mx4MxNLDiajiWQgDlBDeRgL4+Lwe0d7JnMkELNDL/a3f8bxfXmDegut6tD08WWzUc24W5VdZMlfKVKwpOVJ5a0CgYByPWRuA7yJ+cWkmZl9yMCpNziSJgm7A1TwI9SRpfgx+azrLVSPZAYKzwmpsiOmuD/SSyDS7YE2d4QT/C+jbGlGYa3pGN7XUqmJVPhn9sJzoCHQf5LPbS5cLRC0c0qjFwsOw5hTVa0pPTiyRjF7xKc4yzBotifs4VdhXSH5GurFJg==";

    public static String sign(String content, String privateKey) {
        try {
            PKCS8EncodedKeySpec priPKCS8 = new PKCS8EncodedKeySpec(Base64.getDecoder().decode(privateKey));
            KeyFactory keyFactory = KeyFactory.getInstance(ALGORITHM);
            PrivateKey priKey = keyFactory.generatePrivate(priPKCS8);

            Signature signature = Signature.getInstance(SIGN_SHA256RSA_ALGORITHMS);
            signature.initSign(priKey);
            signature.update(content.getBytes(DEFAULT_CHARSET));
            byte[] signed = signature.sign();
            return Base64.getEncoder().encodeToString(signed);
        } catch (Exception e) {
            e.printStackTrace();
        }

        return null;
    }

}
