package cn.wisenergy.chnmuseum.party.common.video;

import javax.crypto.Cipher;
import java.io.IOException;

public final class AesCipherDataSink implements DataSink {

    private final DataSink wrappedDataSink;
    private final byte[] secretKey;

    private AesFlushingCipher cipher;

    public AesCipherDataSink(byte[] secretKey, DataSink wrappedDataSink) {
        this.wrappedDataSink = wrappedDataSink;
        this.secretKey = secretKey;
    }

    @Override
    public void open() throws IOException {
        wrappedDataSink.open();
        cipher = new AesFlushingCipher(Cipher.ENCRYPT_MODE, secretKey, 0, 0);
    }

    @Override
    public void write(byte[] data, int offset, int length) throws IOException {
        cipher.updateInPlace(data, offset, length);
        wrappedDataSink.write(data, offset, length);
    }

    @Override
    public void close() throws IOException {
        cipher = null;
        wrappedDataSink.close();
    }
}

