package cn.wisenergy.chnmuseum.party.common.video;

import lombok.extern.slf4j.Slf4j;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;

@Slf4j
public class VideoTestUtil {
    private static final String plainFilePath = "D:\\200.tmp\\";
    //此为AES128位，如果要求AES256位，需要更新jdk内的包，jdk8发布版本默认不支持
    private static final String cipher = "3348c95c60520be7";
    private static final int dataLength = 4096;

    public static void main(String[] args) {
        //加密视频
        new Thread(() -> {
            try {
                log.info("开始加解密");
                File f = new File(plainFilePath, "中华人民共和国成立.mp4");
                FileInputStream fis = new FileInputStream(f);

                File encryptFile = new File(plainFilePath, "中华人民共和国成立.chnmuseum");
                AesCipherDataSink encryptingDataSink = new AesCipherDataSink(
                        "3348c95c60520be7".getBytes(StandardCharsets.UTF_8),
                        new DataSink() {
                            private FileOutputStream fileOutputStream;

                            @Override
                            public void open() throws IOException {
                                fileOutputStream = new FileOutputStream(encryptFile);
                            }

                            @Override
                            public void write(byte[] buffer, int offset, int length) throws IOException {
                                fileOutputStream.write(buffer, offset, length);
                            }

                            @Override
                            public void close() throws IOException {
                                fileOutputStream.close();
                            }
                        });
                encryptingDataSink.open();
                int len;
                byte[] buffer = new byte[dataLength];
                while ((len = fis.read(buffer)) != -1) {
                    encryptingDataSink.write(buffer, 0, len);
                }
                encryptingDataSink.close();
                fis.close();
                log.info("加解密完成");
            } catch (Exception e) {
                log.info(e.getLocalizedMessage());
            }
        }).start();
    }
}
