package cn.wisenergy.chnmuseum.party.core.annotations;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * Created by xulinglin on 2019/1/24
 */
@Target({ElementType.METHOD})
@Retention(RetentionPolicy.RUNTIME)
public @interface RedisLock {

    /**
     * 上锁key值
     * @return
     */
    String value() default "";

    /**
     * 上锁超时时间
     * @return
     */
    long timeOut() default 3000;

    /**
     * 是否循环等待获取锁进行执行方法
     * @return
     */
    boolean required() default false;

    /**
     * 循环等待多少时间  时间单位秒
     * @return
     */
    long timeLock() default 0;

    /**
     * 是否开启事务
     * 默认开启
     * @return
     */
    boolean transaction() default true;
}
