package cn.wisenergy.chnmuseum.party.mapper;

import cn.wisenergy.chnmuseum.party.model.Asset;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.apache.ibatis.annotations.Select;

/**
 * <p>
 * 视频 Mapper 接口
 * </p>
 *
 * @author Danny Lee
 * @since 2021-03-16
 */
public interface AssetMapper extends BaseMapper<Asset> {

    @Select("<script>" +
            "SELECT a.*, co.`name` AS video_content_copyright_owner_name, vcc.`name` AS video_content_cat_name " +
            "FROM asset a, video_content vc, copyright_owner co, video_content_cat vcc " +
            "where a.ref_item_id = vc.id " +
            "and vc.video_content_cat_id = vcc.id " +
            "and vc.video_content_copyright_owner_id = co.id " +
            "<if test='videoContentCatId != null'>and vcc.id = #{videoContentCatId} </if>" +
            "<if test='videoContentCopyrightOwnerId != null'>and co.id = #{videoContentCopyrightOwnerId} </if>" +
            "order by a.create_time desc" +
            "</script>")
    Page<Asset> selectPageByConditions(Page<Object> page, String videoContentCatId, String videoContentCopyrightOwnerId);

}
