package cn.wisenergy.chnmuseum.party.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import cn.wisenergy.chnmuseum.party.model.Employee;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * <p>
 * 组织成员 Mapper 接口
 * </p>
 *
 * @author 杨智平
 * @since 2018-08-02
 */
public interface EmployeeMapper extends BaseMapper<Employee> {

    List<Employee> selectRolenameList(Page<Employee> page, @Param(value = "name") String name);

    //给支行管理员查询自己网点人员
    List<Employee> selectOwnEmpList(Page<Employee> page, @Param(value = "name") String name,
                                    @Param(value = "currBankID") String currBankID);

    Employee selectByEmpId(@Param(value = "empId") String empId);

    Employee selectByUsername(@Param(value = "username") String username);

//    List<Employee> getEmpCodeBybankId(@Param(value = "bankId") String bankId);

    Employee getEmpCodeBybankId(@Param(value = "bankId") String bankId);

    //查询当前网点下启用的大堂主管
    List<Employee> selectEmpListByBankId(@Param(value = "employeeId") String employeeId,
                                         @Param(value = "currBankId") String currBankId);

}
