package cn.wisenergy.chnmuseum.party.mapper;

import cn.wisenergy.chnmuseum.party.model.*;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.apache.ibatis.annotations.Param;
import org.mapstruct.Mapper;

import java.util.List;
import java.util.Map;

/**
 * <pre>
 * 展板统计信息表 Mapper 接口
 * </pre>
 *
 * @author Danny Lee
 * @since 2021-03-25
 */
@Mapper
public interface TBoardStatisticMapper extends BaseMapper<TBoardStatistic> {

    public  List<TBoardPlayRank> getBoardRankPageList(Page<TBoardPlayRank> page,TBoardPlayRank rank);

    public  List<TBoardPlayTrend> getBoardTrendPageList(Page<TBoardPlayTrend> page, TBoardPlayTrend trend);

    public  List<TDistrictBoardStatistic> getBoardDistrictPageList(Page<TDistrictBoardStatistic> page, TDistrictBoardStatistic district);

    /**
     * 获取展板播放总量
     * @param survey
     * @return
     */
    Integer getBoardPlayTotal(TBoardSurvey survey);

    /**
     * 获取展板总量
     * @param survey
     * @return
     */
    Integer getBoardTotal(TBoardSurvey survey);
    /**
     * 获取播放展板的机构总量
     * @param survey
     * @return
     */
    Integer getOrganTotal(TBoardSurvey survey);

    /**
     * 获取互动总量
     * @param survey
     * @return
     */
    Integer getInteractionTotal(TBoardSurvey survey);

    List<Map> getInteractionFrequency(Page page,@Param("frequencyDate") String frequencyDate);

}
