package cn.wisenergy.chnmuseum.party.model;

import cn.wisenergy.chnmuseum.party.common.validator.groups.Add;
import cn.wisenergy.chnmuseum.party.common.validator.groups.Update;
import com.baomidou.mybatisplus.annotation.*;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.*;
import lombok.experimental.Accessors;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * <p>
 * 学习内容信息
 * </p>
 *
 * @author Danny Lee
 * @since 2021-03-26
 */
@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@TableName("t_audit")
@ApiModel(value = "学习内容信息", description = "学习内容信息")
public class Audit implements Serializable {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty("审核ID")
    @TableId(value = "id", type = IdType.ASSIGN_ID)
    @NotNull(message = "审核ID不能为空")
    private String id;

    @ApiModelProperty("审核内容")
    @TableField("content")
    private String content;

    @ApiModelProperty("所属机构ID")
    @TableField("organ_id")
    private String organId;

    @ApiModelProperty("审核项ID")
    @TableField("ref_item_id")
    @NotBlank(message = "审核项ID不能为空", groups = {Add.class})
    private String refItemId;

    @ApiModelProperty("提交人员")
    @TableField(value = "user_id", fill = FieldFill.INSERT)
    @NotBlank(message = "提交人员不能为空", groups = {Add.class})
    private String userId;

    @ApiModelProperty(value = "审核内容", allowableValues = "VIDEO_CONTENT,EXHIBITION_BOARD,LEARNING_CONTENT,ACCOUNT")
    @TableField("type")
    @NotBlank(message = "0,看板；1 视频内容；2 学习内容；3 账号禁用不能为空", groups = {Add.class})
    private String type;

    @ApiModelProperty("操作类型")
    @TableField("operation")
    @NotBlank(message = "操作类型不能为空", groups = {Update.class})
    private String operation;

    @ApiModelProperty(value = "审核状态", allowableValues = "TBC,REFUSED,TBCA,APPROVED_FINAL")
    @TableField("status")
    @NotBlank(message = "审核状态不能为空", groups = {Update.class})
    private String status;

    @ApiModelProperty("创建日期")
    @TableField(value = "create_time", fill = FieldFill.INSERT)
    @NotNull(message = "创建日期不能为空", groups = {Add.class})
    private LocalDateTime createTime;

    @ApiModelProperty("初审日期")
    @TableField(value = "first_time", fill = FieldFill.INSERT_UPDATE)
    private LocalDateTime firstTime;

    @ApiModelProperty("复审日期")
    @TableField(value = "second_time", fill = FieldFill.INSERT_UPDATE)
    private LocalDateTime secondTime;

    @ApiModelProperty("0：未删除，1：已删除")
    @TableField("is_deleted")
    private Boolean deleted;

    @ApiModelProperty("初审意见")
    @TableField("first_remarks")
    private String firstRemarks;

    @ApiModelProperty("复审意见")
    @TableField("second_remarks")
    private String secondRemarks;

    @ApiModelProperty(value = "审核层级", allowableValues = "TBC,TBCA")
    @NotBlank(message = "审核层级不能为空", groups = {Update.class})
    @TableField("level")
    private String level;

    @ApiModelProperty("机构名")
    @TableField(exist = false)
    private String orgName;

    @ApiModelProperty("提交人名")
    @TableField(exist = false)
    private String userName;

    @ApiModelProperty("审核项名称")
    @TableField(exist = false)
    private String name;

}
