package cn.wisenergy.chnmuseum.party.model;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;
import java.util.Date;

/**
 * <p>
 * 网点信息表
 * </p>
 *
 * @author 杨智平
 * @since 2018-08-29
 */
@TableName("bank_branch_info")
public class BankBranchInfo extends Model<BankBranchInfo> {

    private static final long serialVersionUID = 1L;

    /**
     * 唯一标识
     */
    @ApiModelProperty("唯一标识")
    @TableId(value = "id", type = IdType.UUID)
    private String id;
    /**
     * 网点名称
     */
    @ApiModelProperty("网点名称")
    private String name;
    /**
     * 网点地址
     */
    @ApiModelProperty("网点地址")
    private String address;

    /**
     * 是否删除
     */
    @ApiModelProperty("是否删除")
    @TableField("is_deleted")
    private Integer isDeleted = 0;

    /**
     * 网点区域分布底图
     */
    @ApiModelProperty("网点区域分布底图")
    @TableField("image_url")
    private String imageUrl;
    /**
     * 网点联系电话
     */
    @ApiModelProperty("网点联系电话")
    @TableField("phone_num")
    private String phoneNum;
    /**
     * 底图宽度
     */
    @ApiModelProperty("底图宽度")
    private String width;
    /**
     * 底图高度
     */
    @ApiModelProperty("底图高度")
    private String height;

    /**
     * 序号
     */
    @ApiModelProperty("序号")
    private Integer sortorder;


    /**
     * 封面图
     */
    @ApiModelProperty("封面图")
    @TableField("head_image")
    private String headImage;

    /**
     * 创建时间
     */
    @ApiModelProperty(hidden = true)
    @TableField("create_time")
    private Date createTime;
    /**
     * 修改时间
     */
    @ApiModelProperty(hidden = true)
    @TableField("update_time")
    private Date updateTime;
    /**
     * 网点状态1-启用0-停用
     */
    @ApiModelProperty("网点状态1-启用0-停用")
    private Integer status;
    /**
     * 网点二维码，点击生成时带上网点ID
     */
    @ApiModelProperty(value = "网点二维码，点击生成时带上网点ID")
    @TableField("bank_qr_code")
    private String bankQrCode;
    /**
     * 驳回原因
     */
    @ApiModelProperty(value = "驳回原因")
    @TableField("reject_reason")
    private String rejectReason;
    /**
     * 创建人ID
     */
    @ApiModelProperty(value = "创建人ID", hidden = true)
    @TableField("creator")
    private String creator;
    /**
     * 修改人ID
     */
    @ApiModelProperty(value = "修改人ID", hidden = true)
    @TableField("modifier")
    private String modifier;

    @ApiModelProperty("状态：0-编辑中1-上线被驳回2-上线审核中3-下线审核中4-上线中5-下线中6-下线被驳回")
    @TableField("is_show")
    private Integer isShow;

    /**
     * 经度
     */
    private String lon;
    /**
     * 纬度
     */
    private String lat;

    /**
     * 审核人
     */
    @ApiModelProperty("审核人")
    @TableField("reviewer")
    private String reviewer;

    @ApiModelProperty("审核人名称")
    @TableField(exist = false)
    private String reviewerName;

    @TableField(exist = false)
    private String creatorName;
    @TableField(exist = false)
    private String modifierName;

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getAddress() {
        return address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public String getImageUrl() {
        return imageUrl;
    }

    public void setImageUrl(String imageUrl) {
        this.imageUrl = imageUrl;
    }

    public String getPhoneNum() {
        return phoneNum;
    }

    public void setPhoneNum(String phoneNum) {
        this.phoneNum = phoneNum;
    }

    public String getWidth() {
        return width;
    }

    public void setWidth(String width) {
        this.width = width;
    }

    public String getHeight() {
        return height;
    }

    public void setHeight(String height) {
        this.height = height;
    }

    public Integer getSortorder() {
        return sortorder;
    }

    public void setSortorder(Integer sortorder) {
        this.sortorder = sortorder;
    }

    public Date getCreateTime() {
        return createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public Date getUpdateTime() {
        return updateTime;
    }

    public void setUpdateTime(Date updateTime) {
        this.updateTime = updateTime;
    }

    public Integer getStatus() {
        return status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public String getBankQrCode() {
        return bankQrCode;
    }

    public void setBankQrCode(String bankQrCode) {
        this.bankQrCode = bankQrCode;
    }


    public String getHeadImage() {
        return headImage;
    }

    public void setHeadImage(String headImage) {
        this.headImage = headImage;
    }

    public String getRejectReason() {
        return rejectReason;
    }

    public void setRejectReason(String rejectReason) {
        this.rejectReason = rejectReason;
    }

    public String getCreator() {
        return creator;
    }

    public void setCreator(String creator) {
        this.creator = creator;
    }

    public String getModifier() {
        return modifier;
    }

    public void setModifier(String modifier) {
        this.modifier = modifier;
    }

    public String getLon() {
        return lon;
    }

    public void setLon(String lon) {
        this.lon = lon;
    }

    public String getLat() {
        return lat;
    }

    public void setLat(String lat) {
        this.lat = lat;
    }

    public String getCreatorName() {
        return creatorName;
    }

    public void setCreatorName(String creatorName) {
        this.creatorName = creatorName;
    }

    public String getModifierName() {
        return modifierName;
    }

    public void setModifierName(String modifierName) {
        this.modifierName = modifierName;
    }

    public Integer getIsDeleted() {
        return isDeleted;
    }

    public void setIsDeleted(Integer isDeleted) {
        this.isDeleted = isDeleted;
    }

    public Integer getIsShow() {
        return isShow;
    }

    public void setIsShow(Integer isShow) {
        this.isShow = isShow;
    }

    public String getReviewer() {
        return reviewer;
    }

    public void setReviewer(String reviewer) {
        this.reviewer = reviewer;
    }

    public String getReviewerName() {
        return reviewerName;
    }

    public void setReviewerName(String reviewerName) {
        this.reviewerName = reviewerName;
    }

    @Override
    protected Serializable pkVal() {
        return this.id;
    }

    @Override
    public String toString() {
        return "BankBranchInfo{" +
                "id='" + id + '\'' +
                ", name='" + name + '\'' +
                ", address='" + address + '\'' +
                ", isDeleted=" + isDeleted +
                ", imageUrl='" + imageUrl + '\'' +
                ", phoneNum='" + phoneNum + '\'' +
                ", width='" + width + '\'' +
                ", height='" + height + '\'' +
                ", sortorder=" + sortorder +
                ", headImage='" + headImage + '\'' +
                ", createTime=" + createTime +
                ", updateTime=" + updateTime +
                ", status=" + status +
                ", bankQrCode='" + bankQrCode + '\'' +
                ", rejectReason='" + rejectReason + '\'' +
                ", creator='" + creator + '\'' +
                ", modifier='" + modifier + '\'' +
                ", isShow=" + isShow +
                ", lon='" + lon + '\'' +
                ", lat='" + lat + '\'' +
                ", reviewer='" + reviewer + '\'' +
                '}';
    }
}
