package cn.wisenergy.chnmuseum.party.model;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * <p>
 * 业务信息表
 * </p>
 *
 * @author 杨智平
 * @since 2018-08-29
 */
@TableName("business_info")
public class BusinessInfo extends Model<BusinessInfo> {

    private static final long serialVersionUID = 1L;

    /**
     * 唯一标识
     */
    @ApiModelProperty("唯一标识")
    @TableId(value = "id", type = IdType.UUID)
    private String id;
    /**
     * 创建人ID(当前登录用户)
     */
    @ApiModelProperty(value = "创建人ID(当前登录用户)", hidden = true)
    private String creator;
    /**
     * 业务名称
     */
    @ApiModelProperty(value = "业务名称", required = true)
    private String name;
    /**
     * 业务图标
     */
    @ApiModelProperty(value = "业务图标", required = true)
    private String icon;
    /**
     * 图标颜色
     */
    @ApiModelProperty(value = "图标颜色")
    @TableField("icon_color")
    private String iconColor;
    /**
     * 业务流程
     */
    @ApiModelProperty(value = "业务描述", required = true)
    private String process;
    /**
     * 业务指南
     */
    @ApiModelProperty("业务指南图片")
    private String guide;
    /**
     * 是否有自助办理跳转链接1-有 2-无
     */
    @ApiModelProperty("是否有自助办理跳转链接1-有 2-无（传String类型）")
    @TableField("is_skip")
    private String isSkip;
    /**
     * 自助办理跳转链接
     */
    @ApiModelProperty("自助办理跳转链接")
    @TableField("skip_link")
    private String skipLink;
    /**
     * 状态
     */
    @ApiModelProperty("状态：0-编辑中1-上线被驳回2-上线审核中3-下线审核中4-上线中5-下线中6-下线被驳回")
    @TableField("status")
    private Integer status;
    /**
     * 审核人
     */
    @ApiModelProperty("审核人")
    @TableField("reviewer")
    private String reviewer;

    @ApiModelProperty("审核人名称")
    @TableField(exist = false)
    private String reviewerName;
    /**
     * 序号
     */
    @ApiModelProperty("序号")
    private Integer sortorder;
    /**
     * 创建时间
     */
    @ApiModelProperty(hidden = true)
    @TableField("create_time")
    private Date createTime;
    /**
     * 修改时间
     */
    @ApiModelProperty(hidden = true)
    @TableField("update_time")
    private Date updateTime;
    /**
     * 修改人ID
     */
    @ApiModelProperty(value = "修改人ID", hidden = true)
    @TableField("modifier")
    private String modifier;
    /**
     * 所属网点ID
     */
    @ApiModelProperty(value = "所属网点ID", required = true)
    @TableField("bank_branch_id")
    private String bankBranchId;

    @ApiModelProperty(value = "驳回原因")
    @TableField("reject_reason")
    private String rejectReason;

    //创建人信息
    @TableField(exist = false)
    private String CreateEmployee;

    //修改人信息
    @TableField(exist = false)
    private String ModifyEmployee;

    //所属网点名称
    @TableField(exist = false)
    private String BankName;

    //供排序使用
    @TableField(exist = false)
    private List<BusinessInfo> oldList;

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getProcess() {
        return process;
    }

    public void setProcess(String process) {
        this.process = process;
    }

    public String getGuide() {
        return guide;
    }

    public void setGuide(String guide) {
        this.guide = guide;
    }

    public String getIsSkip() {
        return isSkip;
    }

    public void setIsSkip(String isSkip) {
        this.isSkip = isSkip;
    }

    public Integer getStatus() {
        return status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public Integer getSortorder() {
        return sortorder;
    }

    public void setSortorder(Integer sortorder) {
        this.sortorder = sortorder;
    }

    public Date getCreateTime() {
        return createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public Date getUpdateTime() {
        return updateTime;
    }

    public void setUpdateTime(Date updateTime) {
        this.updateTime = updateTime;
    }

    public String getCreator() {
        return creator;
    }

    public void setCreator(String creator) {
        this.creator = creator;
    }

    public String getIcon() {
        return icon;
    }

    public void setIcon(String icon) {
        this.icon = icon;
    }

    public String getSkipLink() {
        return skipLink;
    }

    public void setSkipLink(String skipLink) {
        this.skipLink = skipLink;
    }

    public String getModifier() {
        return modifier;
    }

    public void setModifier(String modifier) {
        this.modifier = modifier;
    }

    public String getCreateEmployee() {
        return CreateEmployee;
    }

    public void setCreateEmployee(String createEmployee) {
        CreateEmployee = createEmployee;
    }

    public String getModifyEmployee() {
        return ModifyEmployee;
    }

    public void setModifyEmployee(String modifyEmployee) {
        ModifyEmployee = modifyEmployee;
    }

    public String getIconColor() {
        return iconColor;
    }

    public void setIconColor(String iconColor) {
        this.iconColor = iconColor;
    }

    public String getBankBranchId() {
        return bankBranchId;
    }

    public void setBankBranchId(String bankBranchId) {
        this.bankBranchId = bankBranchId;
    }

    public String getBankName() {
        return BankName;
    }

    public void setBankName(String bankName) {
        BankName = bankName;
    }

    public String getReviewer() {
        return reviewer;
    }

    public void setReviewer(String reviewer) {
        this.reviewer = reviewer;
    }

    public String getRejectReason() {
        return rejectReason;
    }

    public void setRejectReason(String rejectReason) {
        this.rejectReason = rejectReason;
    }

    public String getReviewerName() {
        return reviewerName;
    }

    public void setReviewerName(String reviewerName) {
        this.reviewerName = reviewerName;
    }

    public List<BusinessInfo> getOldList() {
        return oldList;
    }

    public void setOldList(List<BusinessInfo> oldList) {
        this.oldList = oldList;
    }

    @Override
    protected Serializable pkVal() {
        return this.id;
    }
}
