package cn.wisenergy.chnmuseum.party.model;

import cn.wisenergy.chnmuseum.party.common.validator.groups.Add;
import cn.wisenergy.chnmuseum.party.common.validator.groups.Update;
import com.baomidou.mybatisplus.annotation.*;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.*;
import lombok.experimental.Accessors;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.List;

/**
 * <p>
 * 版权方
 * </p>
 *
 * @author Danny Lee
 * @since 2021-03-17
 */
@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@TableName("copyright_owner")
@ApiModel(value = "版权方", description = "版权方")
public class CopyrightOwner implements Serializable {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty("版权方ID")
    @TableId(value = "id", type = IdType.ASSIGN_ID)
    @NotNull(message = "版权方ID不能为空", groups = {Update.class})
    private String id;

    @ApiModelProperty("版权方名称")
    @TableField("name")
    @NotBlank(message = "版权方名称不能为空", groups = {Add.class, Update.class})
    private String name;

    @ApiModelProperty(value = "版权方类型", allowableValues = "VIDEO_CONTENT, EXHIBITION_BOARD")
    @TableField("owner_type")
    @NotBlank(message = "版权方类型不能为空", groups = {Add.class, Update.class})
    private String ownerType;

    @ApiModelProperty("版权方有效期开始")
    @TableField("expire_date_start")
    @NotNull(message = "版权方有效期开始不能为空", groups = {Add.class, Update.class})
    private LocalDate expireDateStart;

    @ApiModelProperty("版权方有效期结束")
    @TableField("expire_date_end")
    @NotNull(message = "版权方有效期结束不能为空", groups = {Add.class, Update.class})
    private LocalDate expireDateEnd;

    @ApiModelProperty("备注")
    @TableField("remarks")
    private String remarks;

    @ApiModelProperty("创建日期")
    @TableField(value = "create_time", fill = FieldFill.INSERT)
    private LocalDateTime createTime;

    @ApiModelProperty("更新日期")
    @TableField(value = "update_time", fill = FieldFill.INSERT_UPDATE)
    private LocalDateTime updateTime;

    @ApiModelProperty("视频内容分类ID集合(详情使用)")
    @TableField(exist = false)
    private List<String> videoContentCatIdList;

    @ApiModelProperty("视频内容分类名称集合(详情使用)")
    @TableField(exist = false)
    private List<String> videoContentCatNameList;

    @ApiModelProperty("视频内容分类名称(列表使用)")
    @TableField(exist = false)
    private String videoContentCatNames;

}
