package cn.wisenergy.chnmuseum.party.model;

import cn.wisenergy.chnmuseum.party.common.validator.groups.Add;
import cn.wisenergy.chnmuseum.party.common.validator.groups.Update;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.*;
import lombok.experimental.Accessors;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * <p>
 * 版权方视频分类
 * </p>
 *
 * @author Danny Lee
 * @since 2021-04-02
 */
@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@TableName("copyright_owner_video_content_cat")
@ApiModel(value = "版权方视频内容分类", description = "版权方视频内容分类")
public class CopyrightOwnerVideoContentCat implements Serializable {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty("标识ID")
    @TableId(value = "id", type = IdType.ASSIGN_ID)
    @NotNull(message = "标识ID不能为空", groups = {Update.class})
    private String id;

    @ApiModelProperty("视频内容版权方ID")
    @TableField("copyright_owner_id")
    @NotBlank(message = "视频内容版权方ID不能为空", groups = {Add.class, Update.class})
    private String copyrightOwnerId;

    @ApiModelProperty("视频内容分类ID")
    @TableField("video_content_cat_id")
    @NotBlank(message = "视频内容分类ID不能为空", groups = {Add.class, Update.class})
    private String videoContentCatId;

}
