package cn.wisenergy.chnmuseum.party.model;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;
import java.util.Date;

/**
 * <p>
 * 需求建议信息
 * </p>
 *
 * @author 杨智平
 * @since 2018-08-29
 */
@TableName("demand_info")
public class DemandInfo extends Model<DemandInfo> {

    private static final long serialVersionUID = 1L;

    /**
     * 唯一标识
     */
    @ApiModelProperty("唯一标识")
    @TableId(value = "id", type = IdType.UUID)
    private String id;
    /**
     * 叫号单号
     */
    @ApiModelProperty(value = "叫号单号")
    @TableField("line_number")
    private String lineNumber;
    /**
     * 需求内容
     */
    @ApiModelProperty(value = "需求内容")
    private String content;
    /**
     * 手机号码
     */
    @ApiModelProperty(value = "手机号码")
    @TableField("phone_number")
    private String phoneNumber;
    /**
     * 反馈信息
     */
    @ApiModelProperty("反馈信息")
    @TableField("feedback_info")
    private String feedbackInfo;
    /**
     * 发送人ID
     */
    @ApiModelProperty("发送人ID")
    @TableField("advisor_id")
    private String advisorId;
    /**
     * 消息类型：1-吐槽建议2-呼叫记录
     */
    @ApiModelProperty(value = "消息类型：1-吐槽建议2-呼叫记录")
    private Integer type;
    /**
     * 消息时间
     */
    @ApiModelProperty(value = "消息时间", hidden = true)
    @TableField("create_time")
    private Date createTime;
    /**
     * 反馈页面链接
     */
    @ApiModelProperty("反馈页面链接")
    @TableField("feedback_link")
    private String feedbackLink;
    /**
     * 反馈人ID（发送短信给大堂主管时就进行存储）
     */
    @ApiModelProperty("反馈人ID（发送短信给大堂主管时就进行存储）")
    @TableField("feedback_person_id")
    private String feedbackPersonId;
    /**
     * 网点反馈时间
     */
    @ApiModelProperty(value = "网点反馈时间", hidden = true)
    @TableField("feedback_time")
    private Date feedbackTime;
    /**
     * 属于哪个支行，方便查看每个网点的意见建议
     */
    @ApiModelProperty(value = "属于哪个支行，方便查看每个网点的意见建议")
    @TableField("bank_branch_id")
    private String bankBranchId;

    //反馈人名称
    @TableField(exist = false)
    private String feedbackPersonName;

    //所属支行名称
    @TableField(exist = false)
    private String bankBranchName;

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getLineNumber() {
        return lineNumber;
    }

    public void setLineNumber(String lineNumber) {
        this.lineNumber = lineNumber;
    }

    public String getContent() {
        return content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public String getPhoneNumber() {
        return phoneNumber;
    }

    public void setPhoneNumber(String phoneNumber) {
        this.phoneNumber = phoneNumber;
    }

    public String getFeedbackInfo() {
        return feedbackInfo;
    }

    public void setFeedbackInfo(String feedbackInfo) {
        this.feedbackInfo = feedbackInfo;
    }

    public String getAdvisorId() {
        return advisorId;
    }

    public void setAdvisorId(String advisorId) {
        this.advisorId = advisorId;
    }

    public Integer getType() {
        return type;
    }

    public void setType(Integer type) {
        this.type = type;
    }

    public Date getCreateTime() {
        return createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public String getFeedbackLink() {
        return feedbackLink;
    }

    public void setFeedbackLink(String feedbackLink) {
        this.feedbackLink = feedbackLink;
    }

    public String getFeedbackPersonId() {
        return feedbackPersonId;
    }

    public void setFeedbackPersonId(String feedbackPersonId) {
        this.feedbackPersonId = feedbackPersonId;
    }

    public Date getFeedbackTime() {
        return feedbackTime;
    }

    public void setFeedbackTime(Date feedbackTime) {
        this.feedbackTime = feedbackTime;
    }

    public String getBankBranchId() {
        return bankBranchId;
    }

    public void setBankBranchId(String bankBranchId) {
        this.bankBranchId = bankBranchId;
    }

    public String getFeedbackPersonName() {
        return feedbackPersonName;
    }

    public void setFeedbackPersonName(String feedbackPersonName) {
        this.feedbackPersonName = feedbackPersonName;
    }

    public String getBankBranchName() {
        return bankBranchName;
    }

    public void setBankBranchName(String bankBranchName) {
        this.bankBranchName = bankBranchName;
    }

    @Override
    protected Serializable pkVal() {
        return this.id;
    }

    @Override
    public String toString() {
        return "DemandInfo{" +
                "id='" + id + '\'' +
                ", lineNumber='" + lineNumber + '\'' +
                ", content='" + content + '\'' +
                ", phoneNumber='" + phoneNumber + '\'' +
                ", feedbackInfo='" + feedbackInfo + '\'' +
                ", advisorId='" + advisorId + '\'' +
                ", type=" + type +
                ", createTime=" + createTime +
                ", feedbackLink='" + feedbackLink + '\'' +
                ", feedbackPersonId='" + feedbackPersonId + '\'' +
                ", feedbackTime=" + feedbackTime +
                ", bankBranchId='" + bankBranchId + '\'' +
                ", feedbackPersonName='" + feedbackPersonName + '\'' +
                ", bankBranchName='" + bankBranchName + '\'' +
                '}';
    }
}
