package cn.wisenergy.chnmuseum.party.model;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * <p>
 * 热门产品活动信息表
 * </p>
 *
 * @author 杨智平
 * @since 2018-08-29
 */
@TableName("hot_product_activity")
public class HotProductActivity extends Model<HotProductActivity> {

    private static final long serialVersionUID = 1L;

    /**
     * 唯一标识
     */
    @ApiModelProperty("唯一标识")
    @TableId(value = "id", type = IdType.UUID)
    private String id;
    /**
     * 名称
     */
    @ApiModelProperty("名称")
    private String name;
    /**
     * 文字说明
     */
    @ApiModelProperty("文字说明")
    private String content;
    /**
     * 图片
     */
    @ApiModelProperty("图片")
    @TableField("image_url")
    private String imageUrl;
    /**
     * 1-产品2-活动
     */
    @ApiModelProperty("1-产品2-活动")
    private Integer type;

    @ApiModelProperty("状态：0-编辑中1-上线被驳回2-上线审核中3-下线审核中4-上线中5-下线中6-下线被驳回")
    @TableField("is_show")
    private Integer isShow;
    /**
     * 序号
     */
    @ApiModelProperty("序号")
    private Integer sortorder;
    /**
     * 创建时间
     */
    @ApiModelProperty(hidden = true)
    @TableField("create_time")
    private Date createTime;
    /**
     * 修改时间
     */
    @ApiModelProperty(hidden = true)
    @TableField("update_time")
    private Date updateTime;
    /**
     * 产品活动图标
     */
    @ApiModelProperty("产品活动图标")
    private String icon;
    /**
     * 属于哪个支行，不填时默认每个支行通用
     */
    @ApiModelProperty("属于哪个支行，不填时默认每个支行通用")
    @TableField("bank_branch_id")
    private String bankBranchId;
    /**
     * 创建人ID
     */
    @ApiModelProperty(value = "创建人ID", hidden = true)
    @TableField("creator")
    private String creator;
    /**
     * 修改人ID
     */
    @ApiModelProperty(value = "修改人ID", hidden = true)
    @TableField("modifier")
    private String modifier;
    /**
     * 驳回原因
     */
    @ApiModelProperty(value = "驳回原因")
    @TableField("reject_reason")
    private String rejectReason;

    /**
     * 审核人
     */
    @ApiModelProperty("审核人")
    @TableField("reviewer")
    private String reviewer;


    /**
     * 活动最大预约人数
     */
    @ApiModelProperty("活动最大预约人数")
    @TableField("max_number")
    private Integer maxNumber;

    /**
     * 产品最大预约金额
     */
    @ApiModelProperty("产品最大预约金额")
    @TableField("max_money")
    private Double maxMoney;

    /**
     * 是否可以预约1-可以预约2-不可预约
     */
    @ApiModelProperty("是否可以预约1-可以预约2-不可预约")
    @TableField("is_order")
    private Integer isOrder;

    @ApiModelProperty("审核人名称")
    @TableField(exist = false)
    private String reviewerName;

    @TableField(exist = false)
    private BankBranchInfo bankBranchInfo;
    @TableField(exist = false)
    private Employee employee;
    @TableField(exist = false)
    private String bankName;
    @TableField(exist = false)
    private String creatorName;
    @TableField(exist = false)
    private String modifierName;
    @ApiModelProperty("是否已预约 默认否")
    @TableField(exist = false)
    private String appointment = "false"; // 是否预约 默认否

    //供排序使用
    @TableField(exist = false)
    private List<HotProductActivity> oldList;

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getContent() {
        return content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public String getImageUrl() {
        return imageUrl;
    }

    public void setImageUrl(String imageUrl) {
        this.imageUrl = imageUrl;
    }

    public Integer getType() {
        return type;
    }

    public void setType(Integer type) {
        this.type = type;
    }

    public Integer getIsShow() {
        return isShow;
    }

    public void setIsShow(Integer isShow) {
        this.isShow = isShow;
    }

    public Integer getSortorder() {
        return sortorder;
    }

    public void setSortorder(Integer sortorder) {
        this.sortorder = sortorder;
    }

    public Date getCreateTime() {
        return createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public Date getUpdateTime() {
        return updateTime;
    }

    public void setUpdateTime(Date updateTime) {
        this.updateTime = updateTime;
    }

    public String getIcon() {
        return icon;
    }

    public void setIcon(String icon) {
        this.icon = icon;
    }

    public String getBankBranchId() {
        return bankBranchId;
    }

    public void setBankBranchId(String bankBranchId) {
        this.bankBranchId = bankBranchId;
    }

    public BankBranchInfo getBankBranchInfo() {
        return bankBranchInfo;
    }

    public void setBankBranchInfo(BankBranchInfo bankBranchInfo) {
        this.bankBranchInfo = bankBranchInfo;
    }

    public String getCreator() {
        return creator;
    }

    public void setCreator(String creator) {
        this.creator = creator;
    }

    public String getModifier() {
        return modifier;
    }

    public void setModifier(String modifier) {
        this.modifier = modifier;
    }

    public Employee getEmployee() {
        return employee;
    }

    public void setEmployee(Employee employee) {
        this.employee = employee;
    }

    public String getBankName() {
        return bankName;
    }

    public void setBankName(String bankName) {
        this.bankName = bankName;
    }

    public String getCreatorName() {
        return creatorName;
    }

    public void setCreatorName(String creatorName) {
        this.creatorName = creatorName;
    }

    public String getModifierName() {
        return modifierName;
    }

    public void setModifierName(String modifierName) {
        this.modifierName = modifierName;
    }

    public String getAppointment() {
        return appointment;
    }

    public void setAppointment(String appointment) {
        this.appointment = appointment;
    }

    public String getRejectReason() {
        return rejectReason;
    }

    public void setRejectReason(String rejectReason) {
        this.rejectReason = rejectReason;
    }

    public String getReviewer() {
        return reviewer;
    }

    public void setReviewer(String reviewer) {
        this.reviewer = reviewer;
    }

    public Integer getMaxNumber() {
        return maxNumber;
    }

    public void setMaxNumber(Integer maxNumber) {
        this.maxNumber = maxNumber;
    }

    public Double getMaxMoney() {
        return maxMoney;
    }

    public void setMaxMoney(Double maxMoney) {
        this.maxMoney = maxMoney;
    }

    public Integer getIsOrder() {
        return isOrder;
    }

    public void setIsOrder(Integer isOrder) {
        this.isOrder = isOrder;
    }

    public String getReviewerName() {
        return reviewerName;
    }

    public void setReviewerName(String reviewerName) {
        this.reviewerName = reviewerName;
    }

    public List<HotProductActivity> getOldList() {
        return oldList;
    }

    public void setOldList(List<HotProductActivity> oldList) {
        this.oldList = oldList;
    }

    @Override
    protected Serializable pkVal() {
        return this.id;
    }

    @Override
    public String toString() {
        return "HotProductActivity{" +
                "id='" + id + '\'' +
                ", name='" + name + '\'' +
                ", content='" + content + '\'' +
                ", imageUrl='" + imageUrl + '\'' +
                ", type=" + type +
                ", isShow=" + isShow +
                ", sortorder=" + sortorder +
                ", createTime=" + createTime +
                ", updateTime=" + updateTime +
                ", icon='" + icon + '\'' +
                ", bankBranchId='" + bankBranchId + '\'' +
                ", creator='" + creator + '\'' +
                ", modifier='" + modifier + '\'' +
                ", rejectReason='" + rejectReason + '\'' +
                ", reviewer='" + reviewer + '\'' +
                '}';
    }
}
