package cn.wisenergy.chnmuseum.party.model;

import cn.wisenergy.chnmuseum.party.common.validator.groups.Add;
import cn.wisenergy.chnmuseum.party.common.validator.groups.Update;
import com.baomidou.mybatisplus.annotation.*;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.*;
import lombok.experimental.Accessors;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.List;

/**
 * <p>
 * 学习内容
 * </p>
 *
 * @author Danny Lee
 * @since 2021-03-26
 */
@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@TableName("learning_content")
@ApiModel(value = "学习内容", description = "学习内容")
public class LearningContent implements Serializable {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty("学习内容ID")
    @TableId(value = "id", type = IdType.ASSIGN_ID)
    @NotNull(message = "学习内容ID不能为空", groups = {Update.class})
    private String id;

    @ApiModelProperty("学习内容名称")
    @TableField("name")
    @NotBlank(message = "学习内容名称不能为空", groups = {Add.class, Update.class})
    private String name;

    @ApiModelProperty("学习内容宣传图")
    @TableField("cover")
    @NotBlank(message = "学习内容宣传图不能为空", groups = {Add.class, Update.class})
    private String cover;

    @ApiModelProperty(value = "适用范围", allowableValues = "ALL_PLAT, THIS_ORGAN, THIS_ORGAN_SUB")
    @TableField("applicable_scope")
    @NotBlank(message = "适用范围不能为空", groups = {Add.class, Update.class})
    private String applicableScope;

    @ApiModelProperty(value = "机构编码")
    @TableField("organ_code")
    private String organCode;

    @ApiModelProperty("学习项目ID")
    @TableField("learning_project_id")
    @NotBlank(message = "学习项目ID不能为空", groups = {Add.class, Update.class})
    private String learningProjectId;

    @ApiModelProperty("审核状态")
    @TableField("audit_status")
    private String auditStatus;

    @ApiModelProperty("是否上架")
    @TableField("is_published")
    private Boolean published;

    @ApiModelProperty("是否已删除")
    @TableField("is_deleted")
    private Boolean deleted;

    @ApiModelProperty("排序顺序")
    @TableField("sortorder")
    private Integer sortorder;

    @ApiModelProperty("创建日期")
    @TableField(value = "create_time", fill = FieldFill.INSERT)
    private LocalDateTime createTime;

    @ApiModelProperty("更新日期")
    @TableField(value = "update_time", fill = FieldFill.INSERT_UPDATE)
    private LocalDateTime updateTime;

    @ApiModelProperty("展板分类ID列表")
    @TableField(exist = false)
    @NotNull(message = "展板分类ID列表不能为空", groups = {Add.class})
    private List<String> exhibitionBoardCatIdList;

    @ApiModelProperty("版权方ID列表")
    @TableField(exist = false)
    @NotNull(message = "版权方ID列表不能为空", groups = {Add.class})
    private List<String> copyrightOwnerIdList;

    @ApiModelProperty("展板内容ID列表")
    @TableField(exist = false)
    private List<String> exhibitionBoardIdList;

    @ApiModelProperty("展板内容名称列表")
    @TableField(exist = false)
    private List<String> exhibitionBoardNameList;

    @ApiModelProperty("展板分类名称列表")
    @TableField(exist = false)
    private List<String> exhibitionBoardCatNameList;

    @ApiModelProperty("版权方名称列表")
    @TableField(exist = false)
    private List<String> copyrightOwnerNameList;

    @ApiModelProperty("学习项目名称")
    @TableField(exist = false)
    private String learningProjectName;

    @ApiModelProperty("展板列表")
    @TableField(exist = false)
    private List<ExhibitionBoard> exhibitionBoardList;

    @ApiModelProperty("所含展板数量(列表使用)")
    @TableField(exist = false)
    private Integer exhibitionBoardCount;

    @ApiModelProperty("展板分类名称集合(列表使用)")
    @TableField(exist = false)
    private String exhibitionBoardCatNames;

    @ApiModelProperty("版权方名称集合(列表使用)")
    @TableField(exist = false)
    private String copyrightOwnerNames;

    @ApiModelProperty("审核意见记录")
    @TableField(exist = false)
    private List<Audit> auditHistoryList;

}
