package cn.wisenergy.chnmuseum.party.model;

import cn.wisenergy.chnmuseum.party.common.validator.groups.Add;
import cn.wisenergy.chnmuseum.party.common.validator.groups.Update;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.*;
import lombok.experimental.Accessors;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * <p>
 * 学习内容版权方
 * </p>
 *
 * @author Danny Lee
 * @since 2021-03-26
 */
@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@TableName("learning_content_copyright_owner")
@ApiModel(value = "学习内容版权方", description = "学习内容版权方")
public class LearningContentCopyrightOwner implements Serializable {

    private static final long serialVersionUID = 1L;

    @TableId(value = "id", type = IdType.ASSIGN_ID)
    @NotNull(message = "不能为空", groups = {Update.class})
    private String id;

    @ApiModelProperty("学习内容ID")
    @TableField("learning_content_id")
        @NotBlank(message = "学习内容ID不能为空", groups = {Add.class, Update.class})
        private String learningContentId;
    
    @ApiModelProperty("版权方ID")
    @TableField("copyright_owner_id")
        @NotBlank(message = "版权方ID不能为空", groups = {Add.class, Update.class})
        private String copyrightOwnerId;
    



}
