package cn.wisenergy.chnmuseum.party.model;

import cn.wisenergy.chnmuseum.party.common.validator.groups.Add;
import cn.wisenergy.chnmuseum.party.common.validator.groups.Update;
import com.baomidou.mybatisplus.annotation.*;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.*;
import lombok.experimental.Accessors;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * <p>
 *
 * </p>
 *
 * @author Danny Lee
 * @since 2021-03-26
 */
@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@TableName("learning_project")
@ApiModel(value = "", description = "")
public class LearningProject implements Serializable {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty("学习项目ID")
    @TableId(value = "id", type = IdType.ASSIGN_ID)
    @NotNull(message = "学习项目ID不能为空", groups = {Update.class})
    private String id;

    @ApiModelProperty("学习项目名称")
    @TableField("name")
    @NotBlank(message = "学习项目名称不能为空", groups = {Add.class, Update.class})
    private String name;

    @ApiModelProperty("备注")
    @TableField("remarks")
    private String remarks;

    @ApiModelProperty("创建日期")
    @TableField(value = "create_time", fill = FieldFill.INSERT)
    private LocalDateTime createTime;

    @ApiModelProperty("更新日期")
    @TableField(value = "update_time", fill = FieldFill.INSERT_UPDATE)
    private LocalDateTime updateTime;

    @ApiModelProperty("相关学习内容")
    @TableField(exist = false)
    private String learningContentNames;

}
