package cn.wisenergy.chnmuseum.party.model;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * <p>
 * 菜单权限表
 * </p>
 *
 * @author 杨智平
 * @since 2018-08-03
 */
@TableName("menu")
public class Menu extends Model<Menu> {

    private static final long serialVersionUID = 1L;

    @TableId(value = "id", type = IdType.UUID)
    private String id;
    /**
     * 创建时间
     */
    @ApiModelProperty(value = "创建时间", hidden = true)
    @TableField("create_time")
    private Date createTime;
    /**
     * 修改时间
     */
    @ApiModelProperty(value = "修改时间", hidden = true)
    @TableField("update_time")
    private Date updateTime;
    /**
     * 0：未删除，1：已删除
     */
    @ApiModelProperty(value = "0：未删除，1：已删除", hidden = true)
    @TableField("is_deleted")
    private Integer isDeleted = 0;
    /**
     * 菜单地址
     */
    @ApiModelProperty(value = "菜单地址")
    @TableField("url")
    private String url;
    /**
     * 菜单名称
     */
    @ApiModelProperty(value = "菜单名称")
    @TableField("name")
    private String name;
    /**
     * 上级菜单ID
     */
    @ApiModelProperty(value = "上级菜单ID")
    @TableField("parent_id")
    private String parentId;
    /**
     * 1：目录菜单 2：基本操作按钮
     */
    @TableField("is_button")
    private Integer isButton;
    /**
     * 排序
     */
    @TableField("sort")
    @ApiModelProperty(value = "排序")
    private Integer sort;

    /**
     * 级别
     */
    @TableField("level")
    @ApiModelProperty(value = "级别")
    private Integer level;

    /**
     * 图标
     */
    @TableField("icon")
    @ApiModelProperty(value = "图标")
    private String icon;

    /**
     * 页面风格
     */
    @TableField("color")
    @ApiModelProperty(value = "页面风格")
    private String color;

    /**
     * 头像
     */
    @TableField("avatar")
    @ApiModelProperty(value = "头像")
    private String avatar;

    /**
     * 下级
     */
    @TableField(exist = false)
    @ApiModelProperty(value = "下级")
    private List<Menu> children;


    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Date getCreateTime() {
        return createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public Date getUpdateTime() {
        return updateTime;
    }

    public void setUpdateTime(Date updateTime) {
        this.updateTime = updateTime;
    }

    public Integer getIsDeleted() {
        return isDeleted;
    }

    public void setIsDeleted(Integer isDeleted) {
        this.isDeleted = isDeleted;
    }

    public String getUrl() {
        return url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getParentId() {
        return parentId;
    }

    public void setParentId(String parentId) {
        this.parentId = parentId;
    }

    public Integer getIsButton() {
        return isButton;
    }

    public void setIsButton(Integer isButton) {
        this.isButton = isButton;
    }

    public Integer getSort() {
        return sort;
    }

    public void setSort(Integer sort) {
        this.sort = sort;
    }

    public Integer getLevel() {
        return level;
    }

    public void setLevel(Integer level) {
        this.level = level;
    }

    public List<Menu> getChildren() {
        return children;
    }

    public void setChildren(List<Menu> children) {
        this.children = children;
    }

    public String getIcon() {
        return icon;
    }

    public void setIcon(String icon) {
        this.icon = icon;
    }

    public String getColor() {
        return color;
    }

    public void setColor(String color) {
        this.color = color;
    }

    public String getAvatar() {
        return avatar;
    }

    public void setAvatar(String avatar) {
        this.avatar = avatar;
    }

    @Override
    public String toString() {
        return "Menu{" +
                "id='" + id + '\'' +
                ", createTime=" + createTime +
                ", updateTime=" + updateTime +
                ", isDeleted=" + isDeleted +
                ", url='" + url + '\'' +
                ", name='" + name + '\'' +
                ", parentId='" + parentId + '\'' +
                ", isButton=" + isButton +
                ", sort=" + sort +
                ", level=" + level +
                ", icon='" + icon + '\'' +
                ", color='" + color + '\'' +
                ", avatar='" + avatar + '\'' +
                ", children=" + children +
                '}';
    }

    @Override
    protected Serializable pkVal() {
        return this.id;
    }


}
