package cn.wisenergy.chnmuseum.party.model;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;
import java.util.Date;

/**
 * <p>
 * 产品活动预约记录表
 * </p>
 *
 * @author 杨智平
 * @since 2018-08-29
 */
@TableName("product_appointment_record")
public class ProductAppointmentRecord extends Model<ProductAppointmentRecord> {

    private static final long serialVersionUID = 1L;

    /**
     * 唯一标识
     */
    @ApiModelProperty("唯一标识")
    @TableId(value = "id", type = IdType.UUID)
    private String id;
    /**
     * 预约产品或者活动的ID
     */
    @ApiModelProperty("预约产品或者活动的ID")
    @TableField("pro_act_id")
    private String proActId;
    @TableField(exist = false)
    @ApiModelProperty(hidden = true)
    private String proActName; // 产品活动名称
    /**
     * 预约人姓名
     */
    @ApiModelProperty("预约人姓名")
    private String name;
    /**
     * 预约人手机号
     */
    @ApiModelProperty("预约人手机号")
    @TableField("phone_number")
    private String phoneNumber;
    /**
     * 预约详情，手动输入
     */
    @ApiModelProperty("预约详情，手动输入")
    private String detail;
    /**
     * 预约时间
     */
    @ApiModelProperty(value = "预约时间", hidden = true)
    @TableField("create_time")
    private Date createTime;
    /**
     * 修改时间
     */
    @ApiModelProperty(value = "修改时间", hidden = true)
    @TableField("update_time")
    private Date updateTime;
    /**
     * 预约人ID
     */
    @ApiModelProperty("预约人ID")
    @TableField("book_people_id")
    private String bookPeopleId;
    /**
     * 接收人ID
     */
    @ApiModelProperty("接收人ID")
    @TableField("recipient_id")
    private String recipientId;
    /**
     * 预约所属支行
     */
    @ApiModelProperty("预约所属支行")
    @TableField("bank_branch_id")
    private String bankBranchId;
    /**
     * 1-产品2-活动
     */
    @ApiModelProperty("1-产品2-活动")
    private Integer type;
    /**
     * 金额
     */
    @ApiModelProperty("金额")
    private Double money;
    /**
     * 人数
     */
    @ApiModelProperty("人数")
    @TableField("number_of_people")
    private Integer numberOfPeople;

    @TableField(exist = false)
    private BankBranchInfo bankBranchInfo;
    @TableField(exist = false)
    private String bankName;
    @TableField(exist = false)
    private String icon;

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getProActId() {
        return proActId;
    }

    public void setProActId(String proActId) {
        this.proActId = proActId;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getPhoneNumber() {
        return phoneNumber;
    }

    public void setPhoneNumber(String phoneNumber) {
        this.phoneNumber = phoneNumber;
    }

    public String getDetail() {
        return detail;
    }

    public void setDetail(String detail) {
        this.detail = detail;
    }

    public Date getCreateTime() {
        return createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public Date getUpdateTime() {
        return updateTime;
    }

    public void setUpdateTime(Date updateTime) {
        this.updateTime = updateTime;
    }

    public String getProActName() {
        return proActName;
    }

    public void setProActName(String proActName) {
        this.proActName = proActName;
    }

    public String getBookPeopleId() {
        return bookPeopleId;
    }

    public void setBookPeopleId(String bookPeopleId) {
        this.bookPeopleId = bookPeopleId;
    }

    public String getRecipientId() {
        return recipientId;
    }

    public void setRecipientId(String recipientId) {
        this.recipientId = recipientId;
    }

    public String getBankBranchId() {
        return bankBranchId;
    }

    public void setBankBranchId(String bankBranchId) {
        this.bankBranchId = bankBranchId;
    }

    public BankBranchInfo getBankBranchInfo() {
        return bankBranchInfo;
    }

    public void setBankBranchInfo(BankBranchInfo bankBranchInfo) {
        this.bankBranchInfo = bankBranchInfo;
    }

    public Integer getType() {
        return type;
    }

    public void setType(Integer type) {
        this.type = type;
    }

    public String getBankName() {
        return bankName;
    }

    public void setBankName(String bankName) {
        this.bankName = bankName;
    }

    public Double getMoney() {
        return money;
    }

    public void setMoney(Double money) {
        this.money = money;
    }

    public Integer getNumberOfPeople() {
        return numberOfPeople;
    }

    public void setNumberOfPeople(Integer numberOfPeople) {
        this.numberOfPeople = numberOfPeople;
    }

    public String getIcon() {
        return icon;
    }

    public void setIcon(String icon) {
        this.icon = icon;
    }

    @Override
    protected Serializable pkVal() {
        return this.id;
    }

}
