package cn.wisenergy.chnmuseum.party.model;

import java.math.BigDecimal;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.Version;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.util.List;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.AllArgsConstructor;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import cn.wisenergy.chnmuseum.party.common.validator.groups.Add;
import cn.wisenergy.chnmuseum.party.common.validator.groups.Update;
import com.baomidou.mybatisplus.annotation.TableField;

/**
 * <p>
 * 区域表
 * </p>
 *
 * @author Danny Lee
 * @since 2021-03-24
 */
@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@TableName("t_area")
@ApiModel(value = "区域表", description = "区域表")
public class TArea implements Serializable {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty("ID")
    @TableId(value = "id", type = IdType.ASSIGN_ID)
    @NotNull(message = "ID不能为空", groups = {Update.class})
    private Integer id;

    @ApiModelProperty("名称")
    @TableField("name")
        @NotBlank(message = "名称不能为空", groups = {Add.class, Update.class})
        private String name;
    
    @ApiModelProperty("简称")
    @TableField("sname")
    private String sname;
    
    @ApiModelProperty("代码")
    @TableField("code")
        @NotBlank(message = "代码不能为空", groups = {Add.class, Update.class})
        private String code;
    
    @ApiModelProperty("类型")
    @TableField("type")
        @NotBlank(message = "类型不能为空", groups = {Add.class, Update.class})
        private String type;
    
    @ApiModelProperty("上级代码")
    @TableField("parent_id")
    private String parentId;
    
    @ApiModelProperty("排序")
    @TableField("sort_position")
    private Integer sortPosition;
    
    @ApiModelProperty("经度")
    @TableField("longitude")
    private BigDecimal longitude;
    
    @ApiModelProperty("维度")
    @TableField("latitude")
    private BigDecimal latitude;
    
    @ApiModelProperty("全称")
    @TableField("full_name")
    private String fullName;
    
    @ApiModelProperty("备注")
    @TableField("remarks")
    private String remarks;

    @ApiModelProperty("下级")
    @TableField(exist = false)
    private List<TArea> children;
    



}
