package cn.wisenergy.chnmuseum.party.model;

import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.Version;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.AllArgsConstructor;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import cn.wisenergy.chnmuseum.party.common.validator.groups.Add;
import cn.wisenergy.chnmuseum.party.common.validator.groups.Update;

/**
 * <p>
 * 展板播放排行
 * </p>
 *
 * @author Danny Lee
 * @since 2021-03-26
 */
@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@TableName("t_board_play_rank")
@ApiModel(value = "展板播放排行", description = "展板播放排行")
public class TBoardPlayRank implements Serializable {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty("ID")
    @TableId(value = "id", type = IdType.ASSIGN_ID)
    @NotNull(message = "ID不能为空", groups = {Update.class})
    private String id;

    @ApiModelProperty("看板ID")
    @TableField("board_id")
        @NotBlank(message = "看板ID不能为空", groups = {Add.class, Update.class})
        private String boardId;

    @ApiModelProperty("看板名称")
    @TableField("board_name")
        @NotBlank(message = "看板名称不能为空", groups = {Add.class, Update.class})
        private String boardName;

    @ApiModelProperty("播放次数")
    @TableField("play_number")
    private Integer playNumber;

    @ApiModelProperty("机构id")
    @TableField("organ_id")
    private String organId;

    @ApiModelProperty("播放时间")
    @TableField("play_date")
    private String playDate;


}
