package cn.wisenergy.chnmuseum.party.model;

import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.annotation.IdType;
import java.time.LocalDate;
import com.baomidou.mybatisplus.annotation.Version;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.AllArgsConstructor;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import cn.wisenergy.chnmuseum.party.common.validator.groups.Add;
import cn.wisenergy.chnmuseum.party.common.validator.groups.Update;
import com.baomidou.mybatisplus.annotation.TableField;

/**
 * <p>
 * 展板播放趋势
 * </p>
 *
 * @author Danny Lee
 * @since 2021-03-26
 */
@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@TableName("t_board_play_trend")
@ApiModel(value = "展板播放趋势", description = "展板播放趋势")
public class TBoardPlayTrend implements Serializable {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty("播放次数")
    @TableField("play_number")
    private Integer playNumber;

    @ApiModelProperty("统计时间 yyyy：统计周期为年  yyyyMM：统计周期为月，默认统计当月yyyyMM  ")
    @TableField(exist = false)
    private String playDate;

    @ApiModelProperty("机构id")
    @TableField("organ_id")
    private Integer organId;




}
