package cn.wisenergy.chnmuseum.party.model;

import cn.wisenergy.chnmuseum.party.common.validator.groups.Update;
import com.baomidou.mybatisplus.annotation.*;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.*;
import lombok.experimental.Accessors;

import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * <p>
 * 机顶盒运维信息
 * </p>
 *
 * @author Danny Lee
 * @since 2021-03-25
 */
@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@TableName("t_box_operation")
@ApiModel(value = "机顶盒运维信息", description = "机顶盒运维信息")
public class TBoxOperation implements Serializable {

    private static final long serialVersionUID = 1L;

    @TableId(value = "id", type = IdType.ASSIGN_ID)
    @NotNull(message = "不能为空", groups = {Update.class})
    private String id;

    @ApiModelProperty("机顶盒所属单位id")
    @TableField("organ_id")
    private String organId;

    @ApiModelProperty("mac地址")
    @TableField("mac")
    private String mac;

    @ApiModelProperty("状态 1.未激活 2.已激活 3.故障")
    @TableField("status")
    private Integer status;

    @ApiModelProperty("区域id")
    @TableField("area_id")
    private String areaId;

    @ApiModelProperty(hidden = true)
    @TableField("public_key")
    private String publicKey;

    @ApiModelProperty(hidden = true)
    @TableField("private_key")
    private String privateKey;

    @ApiModelProperty("创建时间")
    @TableField(value = "create_time", fill = FieldFill.INSERT)
    private LocalDateTime createTime;

    @ApiModelProperty("修改时间")
    @TableField(value = "update_time", fill = FieldFill.INSERT_UPDATE)
    private LocalDateTime updateTime;

    @ApiModelProperty("机构名")
    @TableField(exist = false)
    private String organName;

    @ApiModelProperty("区域名")
    @TableField(exist = false)
    private String areaName;

}
