package cn.wisenergy.chnmuseum.party.model;

import cn.wisenergy.chnmuseum.party.common.validator.groups.Add;
import com.baomidou.mybatisplus.annotation.*;
import com.baomidou.mybatisplus.core.conditions.update.Update;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.*;
import lombok.experimental.Accessors;

import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * <p>
 * 视频
 * </p>
 *
 * @author Danny Lee
 * @since 2021-03-22
 */
@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@TableName("t_course_board_link")
@ApiModel(value = "视频", description = "视频")
public class TCourseBoardLink implements Serializable {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty("id")
    @TableId(value = "id", type = IdType.ASSIGN_ID)
    @NotNull(message = "idID不能为空", groups = {Update.class})
    private String id;

    @ApiModelProperty("材料ID")
    @TableField("board_id")
    private String boardId;
    
    @ApiModelProperty("名称")
    @TableField("course_id")
    private String courseId;
    
    @ApiModelProperty("创建时间")
    @TableField(value = "create_time", fill = FieldFill.INSERT)
        @NotNull(message = "创建时间不能为空", groups = {Add.class, Update.class})
        private LocalDateTime createTime;
    
    @ApiModelProperty("0：未删除，1：已删除")
    @TableField("is_deleted")
    private Boolean isDeleted;
    



}
