package cn.wisenergy.chnmuseum.party.model;

import cn.wisenergy.chnmuseum.party.common.validator.groups.Add;
import cn.wisenergy.chnmuseum.party.common.validator.groups.Update;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.Version;
import com.baomidou.mybatisplus.annotation.TableId;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.util.Date;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.AllArgsConstructor;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import com.baomidou.mybatisplus.annotation.TableField;
import org.springframework.format.annotation.DateTimeFormat;

/**
 * <p>
 * 运维日志表
 * </p>
 *
 * @author Danny Lee
 * @since 2021-03-23
 */
@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@TableName("t_operation_log")
@ApiModel(value = "运维日志表", description = "运维日志表")
public class TOperationLog implements Serializable {

    private static final long serialVersionUID = 1L;

    @TableId(value = "id", type = IdType.ASSIGN_ID)
    @NotNull(message = "ID不能为空", groups = {Update.class})
    private String id;

    @ApiModelProperty("运维用户id")
    @TableField("user_id")
        @NotNull(message = "运维用户id不能为空", groups = {Add.class, Update.class})
        private String userId;
    
    @ApiModelProperty("运维区域")
    @TableField("area")
        @NotBlank(message = "运维区域不能为空", groups = {Add.class, Update.class})
        private String area;
    
    @ApiModelProperty("操作内容")
    @TableField("operation_type")
        @NotBlank(message = "操作内容不能为空", groups = {Add.class, Update.class})
        private String operationType;
    
    @ApiModelProperty("创建时间")
    @TableField(value = "create_time", fill = FieldFill.INSERT)
        @NotNull(message = "创建时间不能为空", groups = {Add.class, Update.class})
        private LocalDateTime createTime;


    @ApiModelProperty("运维用户账号")
    @TableField(exist = false)
    private String userName;

    @ApiModelProperty("开始时间")
    @TableField(exist = false)
    @DateTimeFormat(pattern = "yyyy-MM-dd hh:mm:ss")
    private Date startDate;

    @ApiModelProperty("结束时间")
    @TableField(exist = false)
    @DateTimeFormat(pattern = "yyyy-MM-dd hh:mm:ss")
    private Date endDate;
    



}
