package cn.wisenergy.chnmuseum.party.model;

import cn.wisenergy.chnmuseum.party.common.validator.groups.Add;
import cn.wisenergy.chnmuseum.party.common.validator.groups.Update;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.Version;
import com.baomidou.mybatisplus.annotation.TableId;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.util.List;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.AllArgsConstructor;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import com.baomidou.mybatisplus.annotation.TableField;

/**
 * <p>
 * 用户
 * </p>
 *
 * @author Danny Lee
 * @since 2021-03-22
 */
@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@TableName("t_organ")
@ApiModel(value = "用户", description = "用户")
public class TOrgan implements Serializable {

  private static final long serialVersionUID = 1L;

    @ApiModelProperty("机构ID")
    @TableId(value = "id", type = IdType.ASSIGN_ID)
    @NotNull(message = "机构IDID不能为空", groups = {Update.class})
    private String id;

    @ApiModelProperty("机构名称")
    @TableField("name")
        @NotBlank(message = "机构名称不能为空", groups = {Add.class, Update.class})
        private String name;
    
    @ApiModelProperty("父机构ID")
    @TableField("parent_id")
        @NotBlank(message = "父机构ID不能为空", groups = {Add.class, Update.class})
        private String parentId;

    @ApiModelProperty("编码")
    @TableField("code")
    @NotBlank(message = "编码", groups = {Add.class, Update.class})
    private String code;
    
    @ApiModelProperty("0：未删除，1：已删除")
    @TableField("is_deleted")
    private Boolean isDeleted;
    
    @ApiModelProperty("创建时间")
    @TableField(value = "create_time", fill = FieldFill.INSERT)
        @NotNull(message = "创建时间不能为空", groups = {Add.class, Update.class})
        private LocalDateTime createTime;
    
    @ApiModelProperty("修改时间")
    @TableField(value = "update_time", fill = FieldFill.INSERT_UPDATE)
        @NotNull(message = "修改时间不能为空", groups = {Add.class, Update.class})
        private LocalDateTime updateTime;
    
    @ApiModelProperty("区域")
    @TableField("area_id")
        @NotNull(message = "区域不能为空", groups = {Add.class, Update.class})
        private String areaId;
    
    @ApiModelProperty("icon")
    @TableField("icon")
        private String icon;
    
    @ApiModelProperty("备注")
    @TableField("remarks")
        private String remarks;
    
    @ApiModelProperty("级别")
    @TableField("level")
    @NotNull(message = "级别不能为空", groups = {Add.class, Update.class})
    private Integer level;

    @ApiModelProperty("下级机构")
    @TableField(exist = false)
    private List<TOrgan> children;

    @ApiModelProperty("上级机构名")
    @TableField(exist = false)
    private String parentName;

    @ApiModelProperty("区域名")
    @TableField(exist = false)
    private String areaName;

    @ApiModelProperty("区域集合")
    @TableField(exist = false)
    private List<String> areas;

}
