package cn.wisenergy.chnmuseum.party.model;

import cn.wisenergy.chnmuseum.party.common.validator.groups.Add;
import cn.wisenergy.chnmuseum.party.common.validator.groups.Update;
import com.baomidou.mybatisplus.annotation.*;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.*;
import lombok.experimental.Accessors;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.List;

/**
 * <p>
 * 用户
 * </p>
 *
 * @author Danny Lee
 * @since 2021-03-22
 */
@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@TableName("t_user")
@ApiModel(value = "用户", description = "用户")
public class TUser implements Serializable {

    private static final long serialVersionUID = 1L;

    public TUser(String id, String userName, String orgId, String orgName, String jwtToken) {
        this.id = id;
        this.userName = userName;
        this.orgId = orgId;
        this.orgName = orgName;
        this.jwtToken = jwtToken;
    }

    public TUser(String jwtToken) {
        this.jwtToken = jwtToken;
    }

    @ApiModelProperty("用户标识")
    @TableId(value = "id", type = IdType.ASSIGN_ID)
    @NotNull(message = "用户标识ID不能为空", groups = {Update.class})
    private String id;

    @ApiModelProperty("用户名")
    @TableField("user_name")
    @NotBlank(message = "用户名不能为空", groups = {Add.class, Update.class})
    private String userName;

    @TableField("password_hash")
    @NotNull(message = "不能为空", groups = {Add.class})
    private byte[] passwordHash;

    @TableField("password_salt")
    @NotNull(message = "不能为空", groups = {Add.class})
    private byte[] passwordSalt;

    @ApiModelProperty("创建时间")
    @TableField(value = "create_time", fill = FieldFill.INSERT)
    @NotNull(message = "创建时间不能为空", groups = {Add.class})
    private LocalDateTime createTime;

    @ApiModelProperty("修改时间")
    @TableField(value = "update_time", fill = FieldFill.INSERT_UPDATE)
    private LocalDateTime updateTime;

    @ApiModelProperty("所属机构ID")
    @TableField("org_id")
    private String orgId;

    @ApiModelProperty("是否永久用户")
    @TableField("permanent")
    private Boolean permanent;

    @ApiModelProperty("生效日期")
    @TableField("effective_date")
    private LocalDate effectiveDate;

    @ApiModelProperty("失效日期")
    @TableField("exired_date")
    private LocalDate exiredDate;

    @ApiModelProperty(value = "状态", allowableValues = "启用 ENABLE, 禁用DISABLE")
    @TableField("status")
    private String status;

    @ApiModelProperty("手机号")
    @TableField("phone")
    private String phone;

    @ApiModelProperty("邮箱")
    @TableField("email")
    private String email;

    @ApiModelProperty("微信")
    @TableField("we_chat")
    private String weChat;

    @ApiModelProperty("固话")
    @TableField("telephone")
    private String telephone;

    @ApiModelProperty("0：未删除，1：已删除")
    @TableField("is_deleted")
    private Boolean isDeleted;

    @ApiModelProperty("姓名")
    @TableField("real_name")
    private String realName;

    @ApiModelProperty("类型 1.平台账号 2.用户账号 3.机顶盒账号 4.运维账号 5.统计账号")
    @TableField("type")
    private String type;

    @ApiModelProperty(value = "审核状态", allowableValues = "待初审 TBC, 驳回 REFUSED,待复审 TBCA, 通过APPROVED_FINAL")
    @TableField("audit_status")
    private String auditStatus;

    @ApiModelProperty("区域")
    @TableField("area_id")
    private String areaId;

    @ApiModelProperty("机构名称")
    @TableField(exist = false)
    private String orgName;


    @ApiModelProperty("机构编码")
    @TableField(exist = false)
    private String orgCode;

    @ApiModelProperty("角色id集合")
    @TableField(exist = false)
    private List<String> roleList;

    @ApiModelProperty("密码")
    @TableField("password")
    private String password;

    @ApiModelProperty("区域名")
    @TableField(exist = false)
    private String areaName;

    @ApiModelProperty("区域集合")
    @TableField(exist = false)
    private List<String> areas;

    @ApiModelProperty("状态名称")
    @TableField(exist = false)
    private String statusName;

    @TableField(exist = false)
    private String jwtToken;

}
